/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstorebridge.actions;

import org.eclipse.emf.ecp.common.util.DialogHandler;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.Usersession;
import org.eclipse.emf.emfstore.client.model.WorkspaceManager;
import org.eclipse.emf.emfstore.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CreateProjectDialog
extends TitleAreaDialog {
    private Text txtProjectName;
    private Text txtProjectDesc;
    private Usersession session;
    private ProjectSpace projectSpace;

    public CreateProjectDialog(Shell parent, Usersession session) {
        super(parent);
        this.session = session;
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle("Create new project");
        this.setMessage("Enter the name and the description of the project");
        Label name = new Label(contents, 0);
        name.setText("Name:");
        this.txtProjectName = new Text(contents, 2052);
        this.txtProjectName.setSize(150, 20);
        Label desc = new Label(contents, 0);
        desc.setText("Description:");
        this.txtProjectDesc = new Text(contents, 2050);
        this.txtProjectDesc.setSize(150, 60);
        Point defaultMargins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargins.x, defaultMargins.y).generateLayout(contents);
        return contents;
    }

    public ProjectSpace getProjectSpace() {
        return this.projectSpace;
    }

    public void okPressed() {
        new EMFStoreCommand(){

            protected void doRun() {
                try {
                    if (CreateProjectDialog.this.session != null) {
                        WorkspaceManager.getInstance().getCurrentWorkspace().createRemoteProject(CreateProjectDialog.this.session, CreateProjectDialog.this.txtProjectName.getText(), CreateProjectDialog.this.txtProjectDesc.getText());
                    } else {
                        CreateProjectDialog.this.projectSpace = WorkspaceManager.getInstance().getCurrentWorkspace().createLocalProject(CreateProjectDialog.this.txtProjectName.getText(), CreateProjectDialog.this.txtProjectDesc.getText());
                    }
                }
                catch (AccessControlException e) {
                    DialogHandler.showExceptionDialog((Exception)((Object)e));
                }
                catch (EmfStoreException e) {
                    DialogHandler.showExceptionDialog((Exception)((Object)e));
                }
            }
        }.run();
        this.close();
    }

    public void cancelPressed() {
        this.close();
    }
}

