/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.emfstore.client.model.ModelFactory;
import org.eclipse.emf.emfstore.client.model.ModelPackage;
import org.eclipse.emf.emfstore.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.client.model.provider.ClientModelEditPlugin;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.provider.IdentifiableElementItemProvider;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSpaceItemProvider
extends IdentifiableElementItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private Map<Project, ProjectSpace> projectToProjectSpaceMap;

    public ProjectSpaceItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addProjectNamePropertyDescriptor(object);
            this.addProjectDescriptionPropertyDescriptor(object);
            this.addUsersessionPropertyDescriptor(object);
            this.addLastUpdatedPropertyDescriptor(object);
            this.addResourceCountPropertyDescriptor(object);
            this.addDirtyPropertyDescriptor(object);
            this.addOldLogMessagesPropertyDescriptor(object);
            this.addChangedSharedPropertiesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addProjectNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_projectName_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_projectName_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__PROJECT_NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addProjectDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_projectDescription_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_projectDescription_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__PROJECT_DESCRIPTION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addUsersessionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_usersession_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_usersession_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__USERSESSION, true, false, true, null, null, null));
    }

    protected void addLastUpdatedPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_lastUpdated_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_lastUpdated_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__LAST_UPDATED, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addResourceCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_resourceCount_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_resourceCount_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__RESOURCE_COUNT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addDirtyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_dirty_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_dirty_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__DIRTY, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addOldLogMessagesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_oldLogMessages_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_oldLogMessages_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__OLD_LOG_MESSAGES, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addChangedSharedPropertiesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectSpace_changedSharedProperties_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectSpace_changedSharedProperties_feature", "_UI_ProjectSpace_type"), (EStructuralFeature)ModelPackage.Literals.PROJECT_SPACE__CHANGED_SHARED_PROPERTIES, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ModelPackage.Literals.PROJECT_SPACE__PROJECT);
            this.childrenFeatures.add(ModelPackage.Literals.PROJECT_SPACE__PROJECT_ID);
            this.childrenFeatures.add(ModelPackage.Literals.PROJECT_SPACE__BASE_VERSION);
            this.childrenFeatures.add(ModelPackage.Literals.PROJECT_SPACE__LOCAL_OPERATIONS);
            this.childrenFeatures.add(ModelPackage.Literals.PROJECT_SPACE__WAITING_UPLOADS);
            this.childrenFeatures.add(ModelPackage.Literals.PROJECT_SPACE__PROPERTIES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.getResourceLocator().getImage("prj_obj.gif");
    }

    public String getText(Object object) {
        if (object instanceof ProjectSpace) {
            ProjectSpace projectSpace = (ProjectSpace)object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(projectSpace.getProjectName());
            String string = stringBuilder.toString();
            return string;
        }
        return this.getString("_UI_ProjectSpace_type");
    }

    public void notifyChanged(Notification notification) {
        if (notification != null && this.getProjectToProjectSpaceMap().get(notification.getNotifier()) != null) {
            ProjectSpace projectSpace = this.getProjectToProjectSpaceMap().get(notification.getNotifier());
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)projectSpace, true, true));
            return;
        }
        this.notifyChangedGen(notification);
    }

    private void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ProjectSpace.class)) {
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 1: 
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.PROJECT_SPACE__PROJECT, org.eclipse.emf.emfstore.common.model.ModelFactory.eINSTANCE.createProject()));
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.PROJECT_SPACE__PROJECT_ID, org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createProjectId()));
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.PROJECT_SPACE__BASE_VERSION, VersioningFactory.eINSTANCE.createPrimaryVersionSpec()));
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.PROJECT_SPACE__LOCAL_OPERATIONS, ModelFactory.eINSTANCE.createOperationComposite()));
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.PROJECT_SPACE__WAITING_UPLOADS, org.eclipse.emf.emfstore.server.model.ModelFactory.eINSTANCE.createFileIdentifier()));
        newChildDescriptors.add(this.createChildParameter(ModelPackage.Literals.PROJECT_SPACE__PROPERTIES, org.eclipse.emf.emfstore.common.model.ModelFactory.eINSTANCE.createEMFStoreProperty()));
    }

    public ResourceLocator getResourceLocator() {
        return ClientModelEditPlugin.INSTANCE;
    }

    public void setTarget(Notifier target) {
        super.setTarget(target);
        if (target instanceof ProjectSpace) {
            ProjectSpace projectSpace = (ProjectSpace)target;
            Project project = projectSpace.getProject();
            project.eAdapters().add((Object)this);
            this.setTarget((Notifier)project);
            this.getProjectToProjectSpaceMap().put(project, projectSpace);
        }
    }

    public Collection<?> getChildren(Object object) {
        if (object instanceof ProjectSpace) {
            Project project = ((ProjectSpace)object).getProject();
            if (project == null) {
                return Collections.EMPTY_LIST;
            }
            return project.getModelElements();
        }
        return new ArrayList();
    }

    private Map<Project, ProjectSpace> getProjectToProjectSpaceMap() {
        if (this.projectToProjectSpaceMap == null) {
            this.projectToProjectSpaceMap = new HashMap<Project, ProjectSpace>();
        }
        return this.projectToProjectSpaceMap;
    }
}

