/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.validation;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.NoWorkspaceException;
import org.eclipse.emf.ecp.common.util.DialogHandler;
import org.eclipse.emf.ecp.common.util.UiUtil;
import org.eclipse.emf.ecp.validation.ValidationView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ValidateHandler
extends AbstractHandler {
    private Diagnostic diagnostic;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject toValidate = UiUtil.getModelElement((ExecutionEvent)event);
        try {
            if (ECPWorkspaceManager.getInstance().getWorkSpace().isRootObject(toValidate)) {
                toValidate = ECPWorkspaceManager.getInstance().getWorkSpace().getActiveProject().getRootContainer();
            }
        }
        catch (NoWorkspaceException e) {
            return null;
        }
        if (toValidate != null) {
            final EObject validate = toValidate;
            new ECPCommand(validate){

                protected void doRun() {
                    ValidateHandler.this.validateWithoutCommand(validate);
                }
            }.run(false);
        }
        this.instantiateValidationView();
        return null;
    }

    private void instantiateValidationView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ValidationView validationView = null;
        try {
            validationView = (ValidationView)page.showView("org.eclipse.emf.ecp.validation.validationView");
        }
        catch (PartInitException e) {
            DialogHandler.showExceptionDialog((Exception)((Object)e));
        }
        validationView.updateTable(this.diagnostic);
    }

    public void validateWithoutCommand(EObject object) {
        this.diagnostic = Diagnostician.INSTANCE.validate(object);
        if (this.diagnostic.getSeverity() == 4 || this.diagnostic.getSeverity() == 2) {
            for (Diagnostic childDiagnostic : this.diagnostic.getChildren()) {
                switch (childDiagnostic.getSeverity()) {
                    default: 
                }
            }
        }
    }
}

