/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.components;

import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.CustomConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.ui.DecisionBox;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionConfig;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class OptionComponent {
    private Group group;
    private final Conflict conflict;

    public OptionComponent(DecisionBox parent, Conflict conflict) {
        this.conflict = conflict;
        this.group = new Group((Composite)parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        this.group.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalSpan = 2;
        this.group.setLayoutData((Object)gridData);
        this.group.setText("Choose your Option: ");
        for (ConflictOption option : conflict.getOptions()) {
            new OptionContainer(conflict, option);
        }
        this.refreshButtonColor();
    }

    private String generatePrefix(ConflictOption option) {
        String result = "";
        switch (option.getType()) {
            case MyOperation: {
                result = "Keep My Change: ";
                break;
            }
            case TheirOperation: {
                result = "Keep Their Change: ";
                break;
            }
            case Custom: {
                String optionPrefix;
                if (!(option instanceof CustomConflictOption) || (optionPrefix = ((CustomConflictOption)option).getOptionPrefix()) == null) break;
                result = optionPrefix;
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private void addMouseListener(Composite composite, Listener listener) {
        composite.addListener(6, listener);
        composite.addListener(7, listener);
        composite.addListener(3, listener);
        composite.addListener(4, listener);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.addListener(6, listener);
            child.addListener(7, listener);
            child.addListener(3, listener);
            child.addListener(4, listener);
            ++n2;
        }
    }

    public void refreshButtonColor() {
        Control[] controlArray = this.group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control composite = controlArray[n2];
            if (composite instanceof OptionContainer) {
                if (this.conflict.isResolved() && this.conflict.getSolution() == ((OptionContainer)composite).getOption()) {
                    this.setColor((Composite)composite, DecisionConfig.getOptionSelectedBack(), DecisionConfig.getOptionSelectedFor());
                } else {
                    this.setColor((Composite)composite, DecisionConfig.getDefaultColor(), DecisionConfig.getDefaultTextColor());
                }
            }
            ++n2;
        }
    }

    private void setColor(Composite composite, Color background, Color foreground) {
        composite.setBackground(background);
        composite.setForeground(foreground);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setBackground(background);
            control.setForeground(foreground);
            ++n2;
        }
    }

    private void extraAction(OptionContainer composite) {
        if (composite.getOption().optionChosen()) {
            composite.setText();
            composite.layout();
        }
    }

    private final class OptionContainer
    extends Composite {
        private final ConflictOption option;
        private StyledText styledText;

        private OptionContainer(Conflict conflict, ConflictOption option) {
            super((Composite)OptionComponent.this.group, 2050);
            this.option = option;
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 1;
            this.setLayout((Layout)layout);
            this.setLayoutData(new GridData(768));
            this.styledText = new StyledText((Composite)this, 8);
            this.styledText.setCursor(new Cursor((Device)this.getDisplay(), 21));
            this.styledText.setEditable(false);
            this.styledText.setEnabled(false);
            this.styledText.setBackground(this.getBackground());
            this.setText();
            OptionMouseListener listener = new OptionMouseListener(this);
            OptionComponent.this.addMouseListener(this, listener);
        }

        private void setText() {
            String prefix = OptionComponent.this.generatePrefix(this.option);
            String result = DecisionUtil.cutString(this.option.getStrippedOptionLabel(), 50, true);
            this.styledText.setText(String.valueOf(prefix) + " " + result);
            if (prefix != null || prefix != "") {
                StyleRange prefixRange = new StyleRange();
                prefixRange.start = 0;
                prefixRange.length = prefix.length();
                prefixRange.fontStyle = 2;
                this.styledText.setStyleRange(prefixRange);
            }
        }

        public ConflictOption getOption() {
            return this.option;
        }
    }

    private final class OptionMouseListener
    implements Listener {
        private final OptionContainer composite;

        public OptionMouseListener(OptionContainer composite) {
            this.composite = composite;
            composite.setCursor(new Cursor((Device)composite.getDisplay(), 21));
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 7: {
                    OptionComponent.this.refreshButtonColor();
                    break;
                }
                case 6: {
                    if (OptionComponent.this.conflict.isResolved() && OptionComponent.this.conflict.getSolution() == this.composite.getOption()) {
                        OptionComponent.this.setColor(this.composite, DecisionConfig.getOptionSelectedBackEnter(), DecisionConfig.getDefaultTextColor());
                        break;
                    }
                    OptionComponent.this.setColor(this.composite, DecisionConfig.getOptionEnteredColor(), DecisionConfig.getDefaultTextColor());
                    break;
                }
                case 4: {
                    if (this.composite.getOption().hasExtraOptionAction()) {
                        OptionComponent.this.extraAction(this.composite);
                    }
                    if (OptionComponent.this.conflict.isResolved() && OptionComponent.this.conflict.getSolution() == this.composite.getOption()) {
                        OptionComponent.this.conflict.setSolution(null);
                    } else {
                        OptionComponent.this.conflict.setSolution(this.composite.getOption());
                    }
                    OptionComponent.this.refreshButtonColor();
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }
}

