/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictContext;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.MultiReferenceConflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts.SingleReferenceConflict;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceConflict
extends Conflict {
    private final Conflict conflict;

    public ReferenceConflict(Conflict conflict, List<AbstractOperation> myOps, List<AbstractOperation> theirOps) {
        super(myOps, theirOps, conflict.getDecisionManager(), conflict.isLeftMy(), false);
        if (!(conflict instanceof SingleReferenceConflict) && !(conflict instanceof MultiReferenceConflict)) {
            throw new IllegalStateException("Only reference conflicts allowed.");
        }
        this.conflict = conflict;
        this.init();
    }

    @Override
    protected boolean allowOtherOptions() {
        return false;
    }

    @Override
    protected ConflictContext initConflictContext() {
        return this.conflict.getConflictContext();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription desc) {
        return this.conflict.getConflictDescription();
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        for (ConflictOption option : this.conflict.getOptions()) {
            if (option.getType() == ConflictOption.OptionType.MyOperation) {
                option.getOperations().clear();
                option.getOperations().addAll(this.getLeftOperations());
            } else if (option.getType() == ConflictOption.OptionType.TheirOperation) {
                option.getOperations().clear();
                option.getOperations().addAll(this.getRightOperations());
            }
            options.add(option);
        }
    }
}

