/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.conflicts;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.DecisionManager;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.Conflict;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictDescription;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.conflict.ConflictOption;
import org.eclipse.emf.emfstore.client.ui.dialogs.merge.util.DecisionUtil;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceConflict
extends Conflict {
    private boolean containmentConflict = this.getMyOperation(MultiReferenceOperation.class).isAdd() && this.getTheirOperation(MultiReferenceOperation.class).isAdd();

    public MultiReferenceConflict(List<AbstractOperation> addingOperation, List<AbstractOperation> removingOperation, DecisionManager decisionManager, boolean meAdding) {
        super(addingOperation, removingOperation, decisionManager, meAdding, false);
        this.init();
    }

    @Override
    protected ConflictDescription initConflictDescription(ConflictDescription description) {
        String descriptionTxt = "";
        descriptionTxt = this.containmentConflict ? "You have moved [target] to the [feature] reference of [modelelement], on the repository it was moved to [othercontainer]." : (this.isLeftMy() ? "You have added [target] to the [feature] reference of the [modelelement]. This item was removed on the repository." : "The [target] was added to the [feature] reference of the [modelelement] on the repository. You chose to remove it, please decide.");
        description.setDescription(descriptionTxt);
        description.add("target", this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
        description.add("othercontainer", this.getTheirOperation(MultiReferenceOperation.class).getModelElementId());
        description.setImage("multiref.gif");
        return description;
    }

    @Override
    protected void initConflictOptions(List<ConflictOption> options) {
        ConflictOption myOption = new ConflictOption("", ConflictOption.OptionType.MyOperation);
        myOption.addOperations(this.getMyOperations());
        ConflictOption theirOption = new ConflictOption("", ConflictOption.OptionType.TheirOperation);
        theirOption.addOperations(this.getTheirOperations());
        EObject target = this.getDecisionManager().getModelElement((ModelElementId)this.getMyOperation(MultiReferenceOperation.class).getReferencedModelElements().get(0));
        if (this.containmentConflict) {
            myOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + "to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getMyOperation().getModelElementId())));
            theirOption.setOptionLabel("Move " + DecisionUtil.getClassAndName(target) + " to" + DecisionUtil.getClassAndName(this.getDecisionManager().getModelElement(this.getTheirOperation().getModelElementId())));
        } else {
            myOption.setOptionLabel(this.isLeftMy() ? "Add" : "Remove " + DecisionUtil.getClassAndName(target));
            theirOption.setOptionLabel(!this.isLeftMy() ? "Add" : "Remove " + DecisionUtil.getClassAndName(target));
        }
        options.add(myOption);
        options.add(theirOption);
    }
}

