/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.core.subinterfaces;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.EmfStoreController;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.core.AbstractEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.AbstractSubEmfstoreInterface;
import org.eclipse.emf.emfstore.server.core.helper.HistoryCache;
import org.eclipse.emf.emfstore.server.core.subinterfaces.ProjectSubInterfaceImpl;
import org.eclipse.emf.emfstore.server.exceptions.BaseVersionOutdatedException;
import org.eclipse.emf.emfstore.server.exceptions.EmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.server.exceptions.StorageException;
import org.eclipse.emf.emfstore.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.DateVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.HeadVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.Version;
import org.eclipse.emf.emfstore.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionSubInterfaceImpl
extends AbstractSubEmfstoreInterface {
    private HistoryCache historyCache;

    public VersionSubInterfaceImpl(AbstractEmfstoreInterface parentInterface) throws FatalEmfStoreException {
        super(parentInterface);
    }

    @Override
    public void initSubInterface() throws FatalEmfStoreException {
        super.initSubInterface();
        this.historyCache = EmfStoreController.getInstance().getHistoryCache();
    }

    public PrimaryVersionSpec resolveVersionSpec(ProjectId projectId, VersionSpec versionSpec) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            if (versionSpec instanceof PrimaryVersionSpec && ((PrimaryVersionSpec)versionSpec).getIdentifier() >= 0 && ((PrimaryVersionSpec)versionSpec).getIdentifier() < projectHistory.getVersions().size()) {
                return (PrimaryVersionSpec)versionSpec;
            }
            if (versionSpec instanceof HeadVersionSpec) {
                return (PrimaryVersionSpec)ModelUtil.clone((EObject)this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId).getLastVersion().getPrimarySpec());
            }
            if (versionSpec instanceof DateVersionSpec) {
                for (Version version : projectHistory.getVersions()) {
                    LogMessage logMessage = version.getLogMessage();
                    if (logMessage == null || logMessage.getDate() == null || !((DateVersionSpec)versionSpec).getDate().before(logMessage.getDate())) continue;
                    Version previousVersion = version.getPreviousVersion();
                    if (previousVersion == null) {
                        return VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
                    }
                    return previousVersion.getPrimarySpec();
                }
                return projectHistory.getLastVersion().getPrimarySpec();
            }
            if (versionSpec instanceof TagVersionSpec) {
                for (Version version : projectHistory.getVersions()) {
                    for (TagVersionSpec tag : version.getTagSpecs()) {
                        if (!((TagVersionSpec)versionSpec).equals(tag)) continue;
                        return (PrimaryVersionSpec)ModelUtil.clone((EObject)version.getPrimarySpec());
                    }
                }
                throw new InvalidVersionSpecException();
            }
            throw new InvalidVersionSpecException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryVersionSpec createVersion(ProjectId projectId, PrimaryVersionSpec baseVersionSpec, ChangePackage changePackage, LogMessage logMessage, ACUser user) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            long currentTimeMillis = System.currentTimeMillis();
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            EList versions = projectHistory.getVersions();
            if (versions.size() - 1 != baseVersionSpec.getIdentifier()) {
                throw new BaseVersionOutdatedException();
            }
            PrimaryVersionSpec newVersionSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
            newVersionSpec.setIdentifier(baseVersionSpec.getIdentifier() + 1);
            Version newVersion = VersioningFactory.eINSTANCE.createVersion();
            Version previousHeadVersion = (Version)versions.get(versions.size() - 1);
            Project newProjectState = (Project)((ProjectImpl)previousHeadVersion.getProjectState()).copy();
            changePackage.apply(newProjectState);
            newVersion.setProjectState(newProjectState);
            newVersion.setChanges(changePackage);
            logMessage.setDate(new Date());
            logMessage.setAuthor(user.getName());
            newVersion.setLogMessage(logMessage);
            newVersion.setPrimarySpec(newVersionSpec);
            newVersion.setNextVersion(null);
            newVersion.setPreviousVersion(previousHeadVersion);
            versions.add(newVersion);
            try {
                try {
                    this.getResourceHelper().createResourceForProject(newProjectState, newVersion.getPrimarySpec(), projectHistory.getProjectId());
                    this.getResourceHelper().createResourceForChangePackage(changePackage, newVersion.getPrimarySpec(), projectId);
                    this.getResourceHelper().createResourceForVersion(newVersion, projectHistory.getProjectId());
                }
                catch (FatalEmfStoreException e) {
                    previousHeadVersion.setNextVersion(null);
                    versions.remove(newVersion);
                    this.save((EObject)previousHeadVersion);
                    this.save((EObject)projectHistory);
                    throw new StorageException("Couldn't save data in database.", e);
                }
                this.handleOldProjectState(projectId, previousHeadVersion);
                this.save((EObject)previousHeadVersion);
                this.save((EObject)projectHistory);
                this.historyCache.addVersionToCache(projectId, newVersion);
            }
            catch (FatalEmfStoreException e) {
                EmfStoreController.getInstance().shutdown(e);
                throw new EmfStoreException("Shutting down server.");
            }
            ModelUtil.logInfo((String)("Total time for commit: " + (System.currentTimeMillis() - currentTimeMillis)));
            return newVersionSpec;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimaryVersionSpec createVersionForProject(ProjectId projectId, PrimaryVersionSpec baseVersionSpec, ChangePackage changePackage, LogMessage logMessage) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            long currentTimeMillis = System.currentTimeMillis();
            ProjectHistory projectHistory = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId);
            EList versions = projectHistory.getVersions();
            if (versions.size() - 1 != baseVersionSpec.getIdentifier()) {
                throw new BaseVersionOutdatedException();
            }
            PrimaryVersionSpec newVersionSpec = VersioningFactory.eINSTANCE.createPrimaryVersionSpec();
            newVersionSpec.setIdentifier(baseVersionSpec.getIdentifier() + 1);
            Version newVersion = VersioningFactory.eINSTANCE.createVersion();
            Version previousHeadVersion = (Version)versions.get(versions.size() - 1);
            Project newProjectState = (Project)ModelUtil.clone((EObject)previousHeadVersion.getProjectState());
            changePackage.apply(newProjectState);
            newVersion.setProjectState(newProjectState);
            newVersion.setChanges(changePackage);
            logMessage.setDate(new Date());
            newVersion.setLogMessage(logMessage);
            newVersion.setPrimarySpec(newVersionSpec);
            newVersion.setNextVersion(null);
            newVersion.setPreviousVersion(previousHeadVersion);
            versions.add(newVersion);
            try {
                try {
                    this.getResourceHelper().createResourceForProject(newProjectState, newVersion.getPrimarySpec(), projectHistory.getProjectId());
                    this.getResourceHelper().createResourceForChangePackage(changePackage, newVersion.getPrimarySpec(), projectId);
                    this.getResourceHelper().createResourceForVersion(newVersion, projectHistory.getProjectId());
                }
                catch (FatalEmfStoreException e) {
                    previousHeadVersion.setNextVersion(null);
                    versions.remove(newVersion);
                    this.save((EObject)previousHeadVersion);
                    this.save((EObject)projectHistory);
                    throw new StorageException("Couldn't save data in database.");
                }
                this.handleOldProjectState(projectId, previousHeadVersion);
                this.save((EObject)previousHeadVersion);
                this.save((EObject)projectHistory);
                this.historyCache.addVersionToCache(projectId, newVersion);
            }
            catch (FatalEmfStoreException e) {
                EmfStoreController.getInstance().shutdown(e);
                throw new EmfStoreException("Shutting down server.");
            }
            ModelUtil.logInfo((String)("Total time for commit: " + (System.currentTimeMillis() - currentTimeMillis)));
            return newVersionSpec;
        }
    }

    private void handleOldProjectState(ProjectId projectId, Version previousHeadVersion) {
        String property = ServerConfiguration.getProperties().getProperty("emfstore.persistence.version.projectstate", "everyXVersion");
        if (property.equals("everyXVersion")) {
            int x = this.getResourceHelper().getXFromPolicy("emfstore.persistence.version.projectstate.everyxversions", "1", false);
            int lastVersion = previousHeadVersion.getPrimarySpec().getIdentifier();
            if (lastVersion != 0 && lastVersion % x != 0) {
                this.getResourceHelper().deleteProjectState(previousHeadVersion, projectId);
            }
        } else {
            this.getResourceHelper().deleteProjectState(previousHeadVersion, projectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangePackage> getChanges(ProjectId projectId, VersionSpec source, VersionSpec target) throws EmfStoreException {
        Object object = this.getMonitor();
        synchronized (object) {
            boolean updateForward;
            PrimaryVersionSpec resolvedSource = this.resolveVersionSpec(projectId, source);
            PrimaryVersionSpec resolvedTarget = this.resolveVersionSpec(projectId, target);
            if (resolvedSource.getIdentifier() == resolvedTarget.getIdentifier()) {
                return new ArrayList<ChangePackage>();
            }
            boolean bl = updateForward = resolvedTarget.getIdentifier() > resolvedSource.getIdentifier();
            if (resolvedSource.getIdentifier() < resolvedTarget.getIdentifier()) {
                resolvedSource.setIdentifier(resolvedSource.getIdentifier() + 1);
            } else {
                resolvedTarget.setIdentifier(resolvedTarget.getIdentifier() + 1);
            }
            ArrayList<ChangePackage> result = new ArrayList<ChangePackage>();
            for (Version version : this.getVersions(projectId, resolvedSource, resolvedTarget)) {
                ChangePackage changes = version.getChanges();
                changes.setLogMessage((LogMessage)ModelUtil.clone((EObject)version.getLogMessage()));
                result.add(changes);
            }
            if (!updateForward) {
                ArrayList<ChangePackage> resultReverse = new ArrayList<ChangePackage>();
                for (ChangePackage changePackage : result) {
                    ChangePackage changePackageReverse = changePackage.reverse();
                    changePackageReverse.setLogMessage((LogMessage)ModelUtil.clone((EObject)changePackage.getLogMessage()));
                    resultReverse.add(changePackageReverse);
                }
                Collections.reverse(resultReverse);
                result = resultReverse;
            }
            return result;
        }
    }

    protected Version getVersion(ProjectId projectId, PrimaryVersionSpec versionSpec) throws EmfStoreException {
        EList versions = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId).getVersions();
        if (versionSpec.getIdentifier() < 0 || versionSpec.getIdentifier() > versions.size() - 1) {
            throw new InvalidVersionSpecException();
        }
        return (Version)versions.get(versionSpec.getIdentifier());
    }

    protected List<Version> getVersions(ProjectId projectId, PrimaryVersionSpec source, PrimaryVersionSpec target) throws EmfStoreException {
        if (source.compareTo((Object)target) < 1) {
            EList versions = this.getSubInterface(ProjectSubInterfaceImpl.class).getProject(projectId).getVersions();
            if (source.getIdentifier() < 0 || source.getIdentifier() > versions.size() - 1 || target.getIdentifier() < 0 || target.getIdentifier() > versions.size() - 1) {
                throw new InvalidVersionSpecException();
            }
            ArrayList<Version> result = new ArrayList<Version>();
            ListIterator iter = versions.listIterator(source.getIdentifier());
            int steps = target.getIdentifier() - source.getIdentifier();
            while (iter.hasNext() && steps-- >= 0) {
                result.add((Version)iter.next());
            }
            return result;
        }
        return this.getVersions(projectId, target, source);
    }
}

