/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.accesscontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionElement;
import org.eclipse.emf.emfstore.common.extensionpoint.ExtensionPoint;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.ServerConfiguration;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthenticationControl;
import org.eclipse.emf.emfstore.server.accesscontrol.AuthorizationControl;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.AbstractAuthenticationControl;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.factory.AuthenticationControlFactory;
import org.eclipse.emf.emfstore.server.accesscontrol.authentication.factory.AuthenticationControlFactoryImpl;
import org.eclipse.emf.emfstore.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.server.exceptions.AccessControlException;
import org.eclipse.emf.emfstore.server.exceptions.FatalEmfStoreException;
import org.eclipse.emf.emfstore.server.exceptions.SessionTimedOutException;
import org.eclipse.emf.emfstore.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.server.model.ProjectId;
import org.eclipse.emf.emfstore.server.model.ServerSpace;
import org.eclipse.emf.emfstore.server.model.SessionId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.server.model.accesscontrol.roles.ServerAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessControlImpl
implements AuthenticationControl,
AuthorizationControl {
    private Map<SessionId, ACUserContainer> sessionUserMap = new HashMap<SessionId, ACUserContainer>();
    private ServerSpace serverSpace;
    private AbstractAuthenticationControl authenticationControl;

    public AccessControlImpl(ServerSpace serverSpace) throws FatalEmfStoreException {
        this.serverSpace = serverSpace;
        this.authenticationControl = this.getAuthenticationFactory().createAuthenticationControl();
    }

    private AuthenticationControlFactory getAuthenticationFactory() {
        for (ExtensionElement e : new ExtensionPoint("org.eclipse.emf.emfstore.server.authenticationfactory").getExtensionElements()) {
            AuthenticationControlFactory factory = (AuthenticationControlFactory)e.getClass("class", AuthenticationControlFactory.class);
            if (factory == null) continue;
            return factory;
        }
        return new AuthenticationControlFactoryImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionId logIn(String username, String password, ClientVersionInfo clientVersionInfo) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor("authentication");
        synchronized (object) {
            ACUser user = this.resolveUser(username);
            SessionId sessionId = this.authenticationControl.logIn(user.getName(), password, clientVersionInfo);
            this.sessionUserMap.put(sessionId, new ACUserContainer(user));
            return sessionId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(SessionId sessionId) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor("authentication");
        synchronized (object) {
            if (sessionId == null) {
                throw new AccessControlException("SessionId is null.");
            }
            this.sessionUserMap.remove(sessionId);
        }
    }

    private ACUser resolveUser(String username) throws AccessControlException {
        Boolean ignoreCase = Boolean.parseBoolean(ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.authentication.matchusers.ignorecase", "false"));
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            for (ACUser user : this.serverSpace.getUsers()) {
                if (ignoreCase.booleanValue()) {
                    if (!user.getName().equalsIgnoreCase(username)) continue;
                    return user;
                }
                if (!user.getName().equals(username)) continue;
                return user;
            }
            throw new AccessControlException();
        }
    }

    @Override
    public void checkSession(SessionId sessionId) throws AccessControlException {
        if (!this.sessionUserMap.containsKey(sessionId)) {
            throw new SessionTimedOutException("Session ID unkown.");
        }
    }

    @Override
    public void checkWriteAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        if (!this.canWrite(roles, projectId, null)) {
            throw new AccessControlException();
        }
    }

    private boolean canWrite(List<Role> roles, ProjectId projectId, EObject modelElement) throws AccessControlException {
        for (Role role : roles) {
            if (!role.canModify(projectId, modelElement) && !role.canCreate(projectId, modelElement) && !role.canDelete(projectId, modelElement)) continue;
            return true;
        }
        return false;
    }

    private boolean canRead(List<Role> roles, ProjectId projectId, EObject modelElement) throws AccessControlException {
        for (Role role : roles) {
            if (!role.canRead(projectId, modelElement)) continue;
            return true;
        }
        return false;
    }

    private List<Role> getRolesFromGroups(ACOrgUnit orgUnit) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (ACGroup group : this.getGroups(orgUnit)) {
            roles.addAll((Collection<Role>)group.getRoles());
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ACGroup> getGroups(ACOrgUnit orgUnit) {
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            ArrayList<ACGroup> groups = new ArrayList<ACGroup>();
            for (ACGroup group : this.serverSpace.getGroups()) {
                if (!group.getMembers().contains((Object)orgUnit)) continue;
                groups.add(group);
                for (ACGroup g : this.getGroups((ACOrgUnit)group)) {
                    if (groups.contains(g)) continue;
                    groups.add(g);
                }
            }
            return groups;
        }
    }

    private ACUser getUser(ACOrgUnitId orgUnitId) throws AccessControlException {
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            for (ACUser user : this.serverSpace.getUsers()) {
                if (!user.getId().equals(orgUnitId)) continue;
                return user;
            }
            throw new AccessControlException("Given User doesn't exist.");
        }
    }

    @Override
    public void checkReadAccess(SessionId sessionId, ProjectId projectId, Set<EObject> modelElements) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        if (!this.canRead(roles, projectId, null)) {
            throw new AccessControlException();
        }
    }

    @Override
    public void checkProjectAdminAccess(SessionId sessionId, ProjectId projectId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        for (Role role : roles) {
            if (!role.canAdministrate(projectId)) continue;
            return;
        }
        throw new AccessControlException();
    }

    @Override
    public void checkServerAdminAccess(SessionId sessionId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser user = this.getUser(sessionId);
        ArrayList<Role> roles = new ArrayList<Role>();
        roles.addAll((Collection<Role>)user.getRoles());
        roles.addAll(this.getRolesFromGroups((ACOrgUnit)user));
        for (Role role : roles) {
            if (!(role instanceof ServerAdmin)) continue;
            return;
        }
        throw new AccessControlException();
    }

    @Override
    public ACUser resolveUser(SessionId sessionId) throws AccessControlException {
        this.checkSession(sessionId);
        ACUser tmpUser = this.sessionUserMap.get(sessionId).getRawUser();
        return this.copyAndResolveUser(tmpUser);
    }

    @Override
    public ACUser resolveUser(ACOrgUnitId id) throws AccessControlException {
        ACUser tmpUser = this.getUser(id);
        return this.copyAndResolveUser(tmpUser);
    }

    private ACUser copyAndResolveUser(ACUser tmpUser) {
        ACUser user = (ACUser)ModelUtil.clone((EObject)tmpUser);
        for (Role role : this.getRolesFromGroups((ACOrgUnit)tmpUser)) {
            user.getRoles().add((Object)((Role)ModelUtil.clone((EObject)role)));
        }
        for (ACGroup group : this.getGroups((ACOrgUnit)tmpUser)) {
            if (user.getEffectiveGroups().contains((Object)group)) continue;
            ACGroup copy = (ACGroup)ModelUtil.clone((EObject)group);
            user.getEffectiveGroups().add((Object)copy);
            copy.getMembers().clear();
        }
        return user;
    }

    private ACUser getUser(SessionId sessionId) throws AccessControlException {
        try {
            return this.sessionUserMap.get(sessionId).getUser();
        }
        catch (AccessControlException e) {
            this.sessionUserMap.remove(sessionId);
            throw e;
        }
    }

    private class ACUserContainer {
        private ACUser acUser;
        private long lastActive;

        public ACUserContainer(ACUser acUser) {
            this.acUser = acUser;
            this.active();
        }

        public ACUser getUser() throws AccessControlException {
            this.checkLastActive();
            this.active();
            return this.getRawUser();
        }

        public ACUser getRawUser() {
            return this.acUser;
        }

        public void checkLastActive() throws AccessControlException {
            String property = ServerConfiguration.getProperties().getProperty("emfstore.accesscontrol.session.timeout", "1800000");
            if (System.currentTimeMillis() - this.lastActive > (long)Integer.parseInt(property)) {
                throw new SessionTimedOutException("Usersession timed out.");
            }
        }

        private void active() {
            this.lastActive = System.currentTimeMillis();
        }
    }
}

