/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.commands.ECPCommandWithParameter;
import org.eclipse.emf.ecp.common.model.ECPMetaModelElementContext;
import org.eclipse.emf.ecp.common.model.ECPModelelementContext;
import org.eclipse.emf.ecp.common.model.workSpaceModel.util.AssociationClassHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteModelElementCommand {
    private final Set<EObject> toBeDeleted;
    private final ECPModelelementContext context;

    public DeleteModelElementCommand(EObject element, ECPModelelementContext context) {
        this(Collections.singleton(element), context);
    }

    public DeleteModelElementCommand(Set<EObject> elements, ECPModelelementContext context) {
        this.toBeDeleted = elements;
        this.context = context;
    }

    public void run() {
        this.removeAnchestorDuplicates(this.toBeDeleted);
        HashSet additionalMEs = new HashSet();
        for (EObject eObject : this.toBeDeleted) {
            additionalMEs.addAll(AssociationClassHelper.getRelatedAssociationClassToDelete((EObject)eObject, (ECPMetaModelElementContext)this.context.getMetaModelElementContext()));
        }
        this.toBeDeleted.addAll(additionalMEs);
        if (this.askConfirmation()) {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            progressDialog.open();
            try {
                this.removeElementsWithoutRoot(this.toBeDeleted);
                if (this.toBeDeleted.size() > 0) {
                    new ECPCommandWithParameter<Set<EObject>>(this.toBeDeleted.iterator().next()){

                        @Override
                        protected void doRun(Set<EObject> parameter) {
                            for (EObject eObject : DeleteModelElementCommand.this.toBeDeleted) {
                                EcoreUtil.delete((EObject)eObject, (boolean)true);
                            }
                        }
                    }.run(this.toBeDeleted);
                }
            }
            finally {
                progressDialog.getProgressMonitor().done();
                progressDialog.close();
            }
        }
    }

    private void removeElementsWithoutRoot(Set<EObject> toBeDeleted) {
        HashSet<EObject> tmpRemove = new HashSet<EObject>();
        for (EObject obj : toBeDeleted) {
            if (obj.eContainer() != null) continue;
            obj.eResource().getContents().remove((Object)obj);
            tmpRemove.add(obj);
        }
        toBeDeleted.removeAll(tmpRemove);
    }

    private void removeAnchestorDuplicates(Set<EObject> toBeDeleted) {
        HashSet<EObject> toBeRemoved = new HashSet<EObject>();
        for (EObject obj : toBeDeleted) {
            if (!this.parentIsContained(toBeDeleted, obj)) continue;
            toBeRemoved.add(obj);
        }
        toBeDeleted.removeAll(toBeRemoved);
    }

    private boolean parentIsContained(Set<EObject> toBeDeleted, EObject obj) {
        EObject container = obj.eContainer();
        if (container == null) {
            return false;
        }
        if (toBeDeleted.contains(container)) {
            return true;
        }
        return this.parentIsContained(toBeDeleted, container);
    }

    private boolean askConfirmation() {
        String question = null;
        ComposedAdapterFactory adapterFactory = null;
        if (this.toBeDeleted.size() == 1) {
            adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
            String modelElementName = adapterFactoryLabelProvider.getText((Object)this.toBeDeleted.iterator().next());
            question = "Do you really want to delete the model element " + modelElementName + "?";
        } else {
            question = "Do you really want to delete these " + this.toBeDeleted.size() + " model elements?";
        }
        MessageDialog dialog = new MessageDialog(null, "Confirmation", null, question, 3, new String[]{"Yes", "No"}, 0);
        boolean confirm = false;
        if (dialog.open() == 0) {
            confirm = true;
        }
        if (adapterFactory != null) {
            adapterFactory.dispose();
        }
        return confirm;
    }
}

