/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.model.versioning.operations.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.emfstore.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.common.model.ModelElementId;
import org.eclipse.emf.emfstore.common.model.Project;
import org.eclipse.emf.emfstore.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.server.model.versioning.operations.impl.FeatureOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiReferenceMoveOperationImpl
extends FeatureOperationImpl
implements MultiReferenceMoveOperation {
    protected static final int OLD_INDEX_EDEFAULT = 0;
    protected int oldIndex = 0;
    protected static final int NEW_INDEX_EDEFAULT = 0;
    protected int newIndex = 0;
    protected ModelElementId referencedModelElementId;

    protected MultiReferenceMoveOperationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return OperationsPackage.Literals.MULTI_REFERENCE_MOVE_OPERATION;
    }

    @Override
    public int getOldIndex() {
        return this.oldIndex;
    }

    @Override
    public void setOldIndex(int newOldIndex) {
        int oldOldIndex = this.oldIndex;
        this.oldIndex = newOldIndex;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, oldOldIndex, this.oldIndex));
        }
    }

    @Override
    public int getNewIndex() {
        return this.newIndex;
    }

    @Override
    public void setNewIndex(int newNewIndex) {
        int oldNewIndex = this.newIndex;
        this.newIndex = newNewIndex;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldNewIndex, this.newIndex));
        }
    }

    @Override
    public ModelElementId getReferencedModelElementId() {
        if (this.referencedModelElementId != null && this.referencedModelElementId.eIsProxy()) {
            InternalEObject oldReferencedModelElementId = (InternalEObject)this.referencedModelElementId;
            this.referencedModelElementId = (ModelElementId)this.eResolveProxy(oldReferencedModelElementId);
            if (this.referencedModelElementId != oldReferencedModelElementId) {
                InternalEObject newReferencedModelElementId = (InternalEObject)this.referencedModelElementId;
                NotificationChain msgs = oldReferencedModelElementId.eInverseRemove((InternalEObject)this, -10, null, null);
                if (newReferencedModelElementId.eInternalContainer() == null) {
                    msgs = newReferencedModelElementId.eInverseAdd((InternalEObject)this, -10, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldReferencedModelElementId, (Object)this.referencedModelElementId));
                }
            }
        }
        return this.referencedModelElementId;
    }

    public ModelElementId basicGetReferencedModelElementId() {
        return this.referencedModelElementId;
    }

    public NotificationChain basicSetReferencedModelElementId(ModelElementId newReferencedModelElementId, NotificationChain msgs) {
        ModelElementId oldReferencedModelElementId = this.referencedModelElementId;
        this.referencedModelElementId = newReferencedModelElementId;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldReferencedModelElementId, (Object)newReferencedModelElementId);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setReferencedModelElementId(ModelElementId newReferencedModelElementId) {
        if (newReferencedModelElementId != this.referencedModelElementId) {
            NotificationChain msgs = null;
            if (this.referencedModelElementId != null) {
                msgs = ((InternalEObject)this.referencedModelElementId).eInverseRemove((InternalEObject)this, -10, null, msgs);
            }
            if (newReferencedModelElementId != null) {
                msgs = ((InternalEObject)newReferencedModelElementId).eInverseAdd((InternalEObject)this, -10, null, msgs);
            }
            if ((msgs = this.basicSetReferencedModelElementId(newReferencedModelElementId, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newReferencedModelElementId, (Object)newReferencedModelElementId));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return this.basicSetReferencedModelElementId(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getOldIndex();
            }
            case 8: {
                return this.getNewIndex();
            }
            case 9: {
                if (resolve) {
                    return this.getReferencedModelElementId();
                }
                return this.basicGetReferencedModelElementId();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setOldIndex((Integer)newValue);
                return;
            }
            case 8: {
                this.setNewIndex((Integer)newValue);
                return;
            }
            case 9: {
                this.setReferencedModelElementId((ModelElementId)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setOldIndex(0);
                return;
            }
            case 8: {
                this.setNewIndex(0);
                return;
            }
            case 9: {
                this.setReferencedModelElementId(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.oldIndex != 0;
            }
            case 8: {
                return this.newIndex != 0;
            }
            case 9: {
                return this.referencedModelElementId != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (oldIndex: ");
        result.append(this.oldIndex);
        result.append(", newIndex: ");
        result.append(this.newIndex);
        result.append(')');
        return result.toString();
    }

    @Override
    public void apply(IdEObjectCollection project) {
        EReference reference;
        EObject modelElement = project.getModelElement(this.getModelElementId());
        EObject referencedModelElement = project.getModelElement(this.getReferencedModelElementId());
        if (modelElement == null) {
            return;
        }
        try {
            reference = (EReference)this.getFeature(modelElement);
        }
        catch (UnkownFeatureException e) {
            return;
        }
        Object object = modelElement.eGet((EStructuralFeature)reference);
        EList list = (EList)object;
        if (this.getNewIndex() >= list.size() || this.getNewIndex() < 0 || referencedModelElement == null || !list.contains((Object)referencedModelElement)) {
            return;
        }
        list.move(this.getNewIndex(), (Object)referencedModelElement);
    }

    @Override
    public boolean canApply(Project project) {
        EReference reference;
        if (!super.canApply(project)) {
            return false;
        }
        EObject modelElement = project.getModelElement(this.getModelElementId());
        if (modelElement == null) {
            return false;
        }
        try {
            reference = (EReference)this.getFeature(modelElement);
        }
        catch (UnkownFeatureException e) {
            return false;
        }
        Object object = modelElement.eGet((EStructuralFeature)reference);
        EList list = (EList)object;
        return this.getNewIndex() < list.size() && this.getNewIndex() >= 0;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Moved ");
        stringBuilder.append(this.getFeatureName().substring(0, this.getFeatureName().length() - 1));
        stringBuilder.append(" from position ");
        stringBuilder.append(this.getOldIndex() + 1);
        stringBuilder.append(" to ");
        stringBuilder.append(this.getNewIndex() + 1);
        stringBuilder.append(".");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Changed order of ");
        stringBuilder.append(this.getFeatureName());
        return stringBuilder.toString();
    }

    @Override
    public AbstractOperation reverse() {
        MultiReferenceMoveOperation multiReferenceMoveOperation = OperationsFactory.eINSTANCE.createMultiReferenceMoveOperation();
        this.reverse(multiReferenceMoveOperation);
        multiReferenceMoveOperation.setNewIndex(this.getOldIndex());
        multiReferenceMoveOperation.setOldIndex(this.getNewIndex());
        multiReferenceMoveOperation.setReferencedModelElementId((ModelElementId)ModelUtil.clone((EObject)this.getReferencedModelElementId()));
        return multiReferenceMoveOperation;
    }

    @Override
    public Set<ModelElementId> getOtherInvolvedModelElements() {
        HashSet<ModelElementId> result = new HashSet<ModelElementId>();
        result.add(this.getReferencedModelElementId());
        return result;
    }
}

