/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emfcloud.jackson.databind.FeatureMapEntryConfig;

public class FeatureMapEntrySerializer
extends JsonSerializer<FeatureMap.Entry> {
    private JsonSerializer<EObject> referenceSerializer;
    private final FeatureMapEntryConfig config;

    public FeatureMapEntrySerializer(JsonSerializer<EObject> referenceSerializer, FeatureMapEntryConfig config) {
        this.referenceSerializer = referenceSerializer;
        this.config = config;
    }

    public void setReferenceSerializer(JsonSerializer<EObject> referenceSerializer) {
        this.referenceSerializer = referenceSerializer;
    }

    public Class<FeatureMap.Entry> handledType() {
        return FeatureMap.Entry.class;
    }

    public void serialize(FeatureMap.Entry entry, JsonGenerator jg, SerializerProvider serializers) throws IOException {
        jg.writeStartObject();
        EStructuralFeature feat = entry.getEStructuralFeature();
        String featureName = this.config.getPropertyName(feat);
        if (this.shouldUseKeyAndValueProperties()) {
            jg.writeStringField("featureName", featureName);
            if (feat instanceof EReference && !((EReference)feat).isContainment()) {
                jg.writeFieldName("value");
                this.referenceSerializer.serialize((Object)((EObject)entry.getValue()), jg, serializers);
            } else {
                jg.writeObjectField("value", entry.getValue());
            }
        } else if (feat instanceof EReference && !((EReference)feat).isContainment()) {
            jg.writeFieldName(featureName);
            this.referenceSerializer.serialize((Object)((EObject)entry.getValue()), jg, serializers);
        } else {
            jg.writeObjectField(featureName, entry.getValue());
        }
        jg.writeEndObject();
    }

    public boolean shouldUseKeyAndValueProperties() {
        return this.config.shouldUseKeyAndValueProperties();
    }
}

