/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.preferences;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.embedcdt.core.Activator;
import org.eclipse.embedcdt.core.AltWindowsRegistry;
import org.eclipse.embedcdt.core.EclipseUtils;
import org.eclipse.embedcdt.core.StringUtils;

public class Discoverer {
    private static final String REG_PREFIX = "SOFTWARE";
    private static final String REG32_PREFIX = "SOFTWARE\\Wow6432Node";

    public static String searchInstallFolder(String executableName, String searchPath, String binFolder) {
        String[] paths;
        String resolvedPath = EclipseUtils.performStringSubstitution(searchPath);
        if (resolvedPath == null || resolvedPath.isEmpty()) {
            return null;
        }
        if (EclipseUtils.isWindows()) {
            resolvedPath = StringUtils.duplicateBackslashes(resolvedPath);
        }
        if ((paths = resolvedPath.split(EclipseUtils.getPathSeparator())).length == 0) {
            return null;
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Discoverer.searchInstallFolder() resolved path \"" + resolvedPath + "\"");
        }
        String value = null;
        int i = 0;
        while (i < paths.length) {
            value = Discoverer.getLastExecutable(paths[i], binFolder, executableName);
            if (value != null && !value.isEmpty()) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public static String getRegistryInstallFolder(String executableName, String subFolder, String registrySubKey, String registryName) {
        WindowsRegistry registry;
        String value = null;
        if (EclipseUtils.isWindows() && (registry = WindowsRegistry.getRegistry()) != null) {
            value = Discoverer.getRegistryValue(registry, REG_PREFIX, registrySubKey, registryName);
            if (value == null) {
                value = Discoverer.getRegistryValue(registry, REG32_PREFIX, registrySubKey, registryName);
            }
            if (subFolder != null && value != null && !value.endsWith("\\" + subFolder)) {
                value = String.valueOf(value) + "\\" + subFolder;
            }
            if (value != null) {
                File folder;
                Path path = new Path(value);
                value = path.toString();
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("Discoverer.getRegistryInstallFolder() " + registryName + " \"" + value + "\"");
                }
                if ((folder = path.append(executableName).toFile()).isFile()) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("Discoverer.getRegistryInstallFolder() = \"" + value + "\"");
                    }
                    return value;
                }
            }
        }
        return null;
    }

    private static String getRegistryValue(WindowsRegistry registry, String prefix, String registrySubKey, String registryName) {
        String value = !registrySubKey.startsWith("\\SEGGER") ? registry.getCurrentUserValue(String.valueOf(prefix) + registrySubKey, registryName) : AltWindowsRegistry.query("HKEY_CURRENT_USER\\" + prefix + registrySubKey, registryName);
        if (value == null) {
            value = registry.getLocalMachineValue(String.valueOf(prefix) + registrySubKey, registryName);
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Discoverer.getRegistryValue(\"" + prefix + "\", \"" + registrySubKey + "\", \"" + registryName + "\") = \"" + value + "\"");
        }
        return value;
    }

    public static String getLastExecutable(String folderName, final String binFolder, final String executableName) {
        Path folderPath = new Path(folderName);
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Discoverer.getLastExecutable(\"" + folderPath + "\", \"" + executableName + "\")");
        }
        ArrayList<String> list = new ArrayList<String>();
        File folder = folderPath.toFile();
        if (!folder.isDirectory()) {
            return null;
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                IPath path = new Path(dir.getAbsolutePath()).append(name);
                path = binFolder != null ? path.append(binFolder).append(executableName) : path.append(executableName);
                if (path.toFile().isFile()) {
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("Discoverer.getLastExecutable() found \"" + path.toString() + "\"");
                    }
                    return true;
                }
                return false;
            }
        });
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                list.add(files[i].getName());
                ++i;
            }
            Collections.sort(list);
            String last = (String)list.get(list.size() - 1);
            IPath path = new Path(folderName).append(last);
            if (binFolder != null) {
                path = path.append(binFolder);
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Discoverer.getLastExecutable() = \"" + path.toString() + "\"");
            }
            return path.toString();
        }
        Path path = new Path(folderName);
        path = binFolder != null ? path.append(binFolder).append(executableName) : path.append(executableName);
        folder = path.toFile();
        if (folder.isFile()) {
            path = new Path(folderName);
            if (binFolder != null) {
                path = path.append(binFolder);
            }
            if (Activator.getInstance().isDebugging()) {
                System.out.println("Discoverer.getLastExecutable() = \"" + path.toString() + "\"");
            }
            return path.toString();
        }
        if (Activator.getInstance().isDebugging()) {
            System.out.println("Discoverer.getLastExecutable() not found");
        }
        return null;
    }
}

