/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.reflog.ReflogItem;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class ReflogViewContentProvider
implements ITreeContentProvider {
    private DeferredTreeContentManager loader;
    private Object currentInput;
    private static final WorkbenchAdapter ERROR_ELEMENT = new WorkbenchAdapter(){

        public String getLabel(Object object) {
            return UIText.ReflogView_ErrorOnLoad;
        }
    };

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(final Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput != null && this.loader != null) {
            this.loader.cancel(oldInput);
        }
        this.currentInput = newInput;
        if (viewer instanceof AbstractTreeViewer && newInput != null) {
            this.loader = new DeferredBatchLoader((AbstractTreeViewer)viewer);
            this.loader.addUpdateCompleteListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult().isOK()) {
                        viewer.setSelection(viewer.getSelection());
                    }
                }
            });
        }
    }

    public void dispose() {
        if (this.currentInput != null && this.loader != null) {
            this.loader.cancel(this.currentInput);
        }
        this.currentInput = null;
        this.loader = null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ReflogInput && this.loader != null) {
            Object[] knownChildren = ((ReflogInput)((Object)parentElement)).getChildren(parentElement);
            if (knownChildren != null) {
                return knownChildren;
            }
            return this.loader.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    private static class DeferredBatchLoader
    extends DeferredTreeContentManager {
        private AbstractTreeViewer viewer;

        public DeferredBatchLoader(AbstractTreeViewer viewer) {
            super(viewer);
            this.viewer = viewer;
        }

        protected void addChildren(Object parent, Object[] children, IProgressMonitor monitor) {
            Control control = this.viewer.getControl();
            if (control == null || control.isDisposed()) {
                return;
            }
            control.getDisplay().syncExec(() -> {
                if (!control.isDisposed()) {
                    try {
                        control.setRedraw(false);
                        if (children.length != 1 || children[0] != ERROR_ELEMENT) {
                            this.viewer.remove((Object)ERROR_ELEMENT);
                        }
                        this.viewer.add(parent, children);
                    }
                    finally {
                        control.setRedraw(true);
                    }
                }
            });
        }
    }

    public static class ReflogInput
    extends WorkbenchAdapter
    implements IDeferredWorkbenchAdapter {
        private final Repository repository;
        private final String ref;
        private final ISchedulingRule rule;
        private ReflogItem[] refLog;

        public ReflogInput(Repository repository, String ref) {
            Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
            Assert.isNotNull((Object)ref, (String)"Ref cannot be null");
            this.repository = repository;
            this.ref = ref;
            this.rule = new ReflogSchedulingRule(repository.getDirectory());
        }

        public Repository getRepository() {
            return this.repository;
        }

        public String getRef() {
            return this.ref;
        }

        public Object[] getChildren(Object o) {
            if (this.refLog != null) {
                return this.refLog;
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (this.refLog != null) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    Git git = new Git(this.repository);
                    try {
                        try (RevWalk walk = new RevWalk(this.repository);){
                            this.refLog = (ReflogItem[])git.reflog().setRef(this.ref).call().stream().map(entry -> {
                                String commitMessage = null;
                                try {
                                    commitMessage = walk.parseCommit((AnyObjectId)entry.getNewId()).getShortMessage();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                return new ReflogItem(this, (ReflogEntry)entry, commitMessage);
                            }).toArray(ReflogItem[]::new);
                            collector.add((Object[])this.refLog, monitor);
                        }
                        if (git == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (git == null) throw throwable;
                        git.close();
                        throw throwable;
                    }
                    git.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Activator.logError("Error running reflog command", e);
                collector.add((Object)ERROR_ELEMENT, monitor);
            }
        }

        public boolean isContainer() {
            return true;
        }

        public ISchedulingRule getRule(Object object) {
            return this.rule;
        }
    }

    private static class ReflogSchedulingRule
    implements ISchedulingRule {
        private final File gitDir;

        public ReflogSchedulingRule(File gitDir) {
            this.gitDir = gitDir;
        }

        public boolean contains(ISchedulingRule rule) {
            if (rule instanceof ReflogSchedulingRule) {
                return Objects.equals(this.gitDir, ((ReflogSchedulingRule)rule).gitDir);
            }
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ReflogSchedulingRule;
        }
    }
}

