/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.configuration;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.annotations.JETAnnotationModel;
import org.eclipse.jet.internal.editor.configuration.par;
import org.eclipse.jet.internal.editor.partition.JETDocumentPartitionScanner;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class JETDocumentProvider
extends FileDocumentProvider {
    private JETTextEditor editor;

    public JETDocumentProvider(JETTextEditor editor) {
        this.editor = editor;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        JETDocumentPartitionScanner partitionScanner = this.editor.getPartitionScanner();
        if (document != null) {
            par partitioner = new par((IPartitionTokenScanner)partitionScanner, partitionScanner.getContentTypes()){

                public IRegion documentChanged2(DocumentEvent e) {
                    JETDocumentProvider.this.editor.handleDocumentChange(e);
                    return super.documentChanged2(e);
                }
            };
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new JETAnnotationModel((IResource)input.getFile());
        }
        return super.createAnnotationModel(element);
    }
}

