/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHelper {
    private ResourceHelper() {
    }

    public static Diagnostic analyzeResourceProblems(Resource resource, Exception exception, String message) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, message, 0, NLS.bind((String)EGFCoreMessages.DiagnosticResourceProblems_message, (Object)resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, message, 0, NLS.bind((String)EGFCoreMessages.DiagnosticResourceProblems_message, (Object)resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public static boolean hasProxyReferences(Resource resource, URI uri) {
        Assert.isNotNull((Object)resource);
        if (uri == null) {
            return false;
        }
        Map proxies = EcoreUtil.ProxyCrossReferencer.find((Resource)resource);
        for (EObject reference : proxies.keySet()) {
            URI innerURI = EcoreUtil.getURI((EObject)reference);
            if (innerURI == null || !innerURI.trimFragment().equals((Object)uri)) continue;
            return true;
        }
        return false;
    }

    public static List<EObject> getProxyReferences(Resource resource, URI uri) {
        Assert.isNotNull((Object)resource);
        UniqueEList references = new UniqueEList();
        if (uri == null) {
            return references;
        }
        Map proxies = EcoreUtil.ProxyCrossReferencer.find((Resource)resource);
        for (EObject reference : proxies.keySet()) {
            URI innerURI = EcoreUtil.getURI((EObject)reference);
            if (innerURI == null || !innerURI.trimFragment().equals((Object)uri)) continue;
            references.add(reference);
        }
        return references;
    }

    public static boolean hasURIProxyReferences(Resource resource, URI uri) {
        Assert.isNotNull((Object)resource);
        if (uri == null) {
            return false;
        }
        Map proxies = EMFHelper.URIProxyCrossReferencer.find((Resource)resource, (URI)uri);
        return proxies != null && proxies.size() > 0;
    }

    public static Map<EObject, Collection<EStructuralFeature.Setting>> getURIProxyReferences(Resource resource, URI uri) {
        Assert.isNotNull((Object)resource);
        HashMap<EObject, Collection<EStructuralFeature.Setting>> references = new HashMap<EObject, Collection<EStructuralFeature.Setting>>();
        if (uri == null) {
            return references;
        }
        return EMFHelper.URIProxyCrossReferencer.find((Resource)resource, (URI)uri);
    }

    public static List<EObject> getURIProxyReferenceOwners(Resource resource, URI uri) {
        Assert.isNotNull((Object)resource);
        UniqueEList owners = new UniqueEList();
        if (uri == null) {
            return owners;
        }
        Iterator<Map.Entry<EObject, Collection<EStructuralFeature.Setting>>> it = ResourceHelper.getURIProxyReferences(resource, uri).entrySet().iterator();
        block0: while (it.hasNext()) {
            for (EStructuralFeature.Setting setting : it.next().getValue()) {
                URI holderURI = EcoreUtil.getURI((EObject)setting.getEObject());
                if (holderURI == null || !resource.getURI().equals((Object)holderURI.trimFragment())) continue;
                owners.add(setting.getEObject());
                continue block0;
            }
        }
        return owners;
    }
}

