/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.internal.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.contributor.EditorMenuContributor;
import org.eclipse.egf.core.ui.contributor.IMenuEditorActionBarContributor;
import org.eclipse.osgi.util.NLS;

public class EditorMenuContributorProxy {
    private IConfigurationElement _element;
    private String _uniqueIdentifier;
    private int _handleId = -1;
    private String _class;
    private Map<IMenuEditorActionBarContributor, EditorMenuContributor> _executables = new HashMap<IMenuEditorActionBarContributor, EditorMenuContributor>();

    public String getUniqueIdentifier() {
        return this._uniqueIdentifier;
    }

    public int getHandleId() {
        return this._handleId;
    }

    public EditorMenuContributor createEditorMenuContributor(IMenuEditorActionBarContributor parent) {
        Object object;
        EditorMenuContributor menu;
        block7: {
            block6: {
                if (parent == null) {
                    return null;
                }
                menu = this._executables.get(parent);
                if (menu != null) {
                    return menu;
                }
                try {
                    object = this._element.createExecutableExtension("class");
                    if (object != null) break block6;
                    return null;
                }
                catch (CoreException e) {
                    EGFCoreUIPlugin.getDefault().logError(e);
                    return null;
                }
            }
            if (object instanceof EditorMenuContributor) break block7;
            EGFCoreUIPlugin.getDefault().logError(NLS.bind((String)EGFCommonMessages.Wrong_Class_Message, (Object)object.getClass().getName()));
            EGFCoreUIPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Wrong_Class_Sub_Type_Message, (Object)EditorMenuContributor.class.getName()), 1);
            EGFCoreUIPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Bundle_Message, (Object)this._element.getContributor().getName()), 1);
            EGFCoreUIPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Extension_Point_Message, (Object)this._element.getName()), 1);
            EGFCoreUIPlugin.getDefault().logInfo(NLS.bind((String)EGFCommonMessages.Attribute_Message, (Object)this._class), 1);
            return null;
        }
        menu = (EditorMenuContributor)object;
        menu.setParentContributor(parent);
        return menu;
    }

    public static EditorMenuContributorProxy createProxy(IConfigurationElement element) {
        String clazz;
        if (element == null) {
            return null;
        }
        IExtension declaringExtension = element.getDeclaringExtension();
        String uniqueIdentifier = declaringExtension.getUniqueIdentifier();
        int handleId = -1;
        if (declaringExtension instanceof Handle) {
            handleId = ((Handle)declaringExtension).getId();
        }
        if ((clazz = element.getAttribute("class")) == null || clazz.trim().length() == 0) {
            return null;
        }
        return new EditorMenuContributorProxy(element, clazz, uniqueIdentifier, handleId);
    }

    public EditorMenuContributorProxy(IConfigurationElement element, String clazz, String uniqueIdentifier, int handleId) {
        this._element = element;
        this._class = clazz.trim();
        if (uniqueIdentifier != null && uniqueIdentifier.trim().length() != 0) {
            this._uniqueIdentifier = uniqueIdentifier.trim();
        }
        this._handleId = handleId;
    }

    public boolean originatesFrom(IExtension extension) {
        String id = extension.getUniqueIdentifier();
        if (id != null) {
            return id.equals(this._uniqueIdentifier);
        }
        if (!(extension instanceof Handle)) {
            return false;
        }
        return this._handleId == ((Handle)extension).getId();
    }

    public void disposeEditorMenuContributor(IMenuEditorActionBarContributor parent) {
        this._executables.remove(parent);
    }

    public void dispose() {
        for (Map.Entry<IMenuEditorActionBarContributor, EditorMenuContributor> entry : this._executables.entrySet()) {
            entry.getKey().removeEditorMenuContributors(Collections.singletonList(entry.getValue()));
        }
        this._executables = null;
    }
}

