/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.Token;
import org.eclipse.fx.code.editor.configuration.TokenScanner;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;
import org.eclipse.fx.code.editor.configuration.gson.GsonTokenScannerImpl;

public final class GsonTokenImpl
implements GsonBase,
Token {
    private final boolean defaultToken;
    private final String name;
    private final List<TokenScanner> tokenScannerList;

    public GsonTokenImpl(JsonObject jsonObject) {
        this.defaultToken = jsonObject.has("defaultToken") ? jsonObject.get("defaultToken").getAsBoolean() : false;
        this.name = jsonObject.has("name") ? jsonObject.get("name").getAsString() : null;
        this.tokenScannerList = jsonObject.has("tokenScannerList") ? Collections.unmodifiableList(StreamSupport.stream(jsonObject.getAsJsonArray("tokenScannerList").spliterator(), false).map(e -> GsonElementFactory.createTokenScanner(e.getAsJsonObject())).collect(Collectors.toList())) : Collections.emptyList();
    }

    public GsonTokenImpl(boolean defaultToken, String name, List<TokenScanner> tokenScannerList) {
        this.defaultToken = defaultToken;
        this.name = name;
        this.tokenScannerList = tokenScannerList;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "Token");
        o.addProperty("defaultToken", Boolean.valueOf(this.isDefaultToken()));
        o.addProperty("name", this.getName());
        o.add("tokenScannerList", (JsonElement)GsonBase.toDomainJsonArray(this.getTokenScannerList()));
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { defaultToken : " + this.defaultToken + ", name : " + this.name + ", tokenScannerList : " + String.valueOf(this.tokenScannerList.stream().map(e -> e.getClass().getSimpleName() + "@" + Integer.toHexString(e.hashCode())).collect(Collectors.toList())) + " }";
    }

    @Override
    public boolean isDefaultToken() {
        return this.defaultToken;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<TokenScanner> getTokenScannerList() {
        return this.tokenScannerList;
    }

    public static class Builder
    implements Token.Builder {
        private final EditorGModel instance;
        private boolean defaultToken;
        private String name;
        private final List<TokenScanner> tokenScannerList = new ArrayList<TokenScanner>();

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder defaultToken(boolean defaultToken) {
            this.defaultToken = defaultToken;
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder tokenScannerList(List<TokenScanner> tokenScannerList) {
            this.tokenScannerList.addAll(tokenScannerList);
            return this;
        }

        @Override
        public Builder appendTokenScannerList(TokenScanner tokenScannerList) {
            this.tokenScannerList.add(tokenScannerList);
            return this;
        }

        @Override
        public Builder tokenScannerList(Function<EditorGModel, List<TokenScanner>> provider) {
            this.tokenScannerList((List)provider.apply(this.instance));
            return this;
        }

        @Override
        public Builder appendTokenScannerList(Function<TokenScanner.Builder, TokenScanner> provider) {
            this.appendTokenScannerList(provider.apply(new GsonTokenScannerImpl.Builder(this.instance)));
            return this;
        }

        @Override
        public Token build() {
            return new GsonTokenImpl(this.defaultToken, this.name, this.tokenScannerList);
        }
    }
}

