/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import jakarta.annotation.PostConstruct;
import java.util.Collection;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.EventProcessor;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuBar;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenuElement;
import org.eclipse.jdt.annotation.NonNull;

public abstract class BaseMenuBarRenderer<N>
extends BaseRenderer<MMenu, WMenuBar<N>>
implements EventProcessor.ChildrenHandler<MMenu, MMenuElement> {
    @PostConstruct
    void init(IEventBroker eventBroker) {
        EventProcessor.attachChildProcessor(eventBroker, this);
        EventProcessor.attachVisibleProcessor(eventBroker, this);
    }

    @Override
    public void doProcessContent(MMenu element) {
        WMenuBar menuBar = (WMenuBar)this.getWidget((MUIElement)element);
        if (menuBar == null) {
            this.getLogger().error("No widget found for '" + String.valueOf(element) + "'");
            return;
        }
        for (MMenuElement e : element.getChildren()) {
            Object widget;
            if (!e.isToBeRendered() || (widget = this.engineCreateWidget(e)) == null || !this.isChildRenderedAndVisible((MUIElement)e)) continue;
            menuBar.addElement((WMenuElement)widget);
        }
    }

    public void childRendered(MMenu parentElement, MUIElement element) {
        if (this.inContentProcessing((MUIElement)parentElement) || !this.isChildRenderedAndVisible(element)) {
            return;
        }
        int idx = this.getRenderedIndex((MUIElement)parentElement, element);
        WMenuBar menu = (WMenuBar)this.getWidget((MUIElement)parentElement);
        if (menu == null) {
            this.getLogger().error("No widget for '" + String.valueOf(menu) + "'");
            return;
        }
        WMenuElement widget = (WMenuElement)element.getWidget();
        if (widget != null) {
            menu.addElement(idx, widget);
        }
    }

    @Override
    public boolean isChildRenderedAndVisible(@NonNull MUIElement u) {
        return this.isChildElementAllowed(u) && super.isChildRenderedAndVisible(u);
    }

    protected boolean isChildElementAllowed(@NonNull MUIElement u) {
        if (!(u instanceof MMenu)) {
            this.getLogger().info(String.valueOf(this.getClass()) + " does not allow an element of type '" + String.valueOf(u.getClass()) + "' as its child");
            return false;
        }
        return true;
    }

    public void hideChild(MMenu container, MUIElement changedObj) {
        WMenuBar menu = (WMenuBar)this.getWidget((MUIElement)container);
        if (menu == null) {
            return;
        }
        WMenuElement widget = (WMenuElement)changedObj.getWidget();
        if (widget != null) {
            menu.removeElement(widget);
        }
    }

    @Override
    public void handleChildrenAddition(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (!element.isToBeRendered() || !this.isChildElementAllowed((MUIElement)element)) continue;
            if (element.getWidget() == null) {
                this.engineCreateWidget(element);
                continue;
            }
            this.childRendered(parent, (MUIElement)element);
        }
    }

    @Override
    public void handleChildrenRemove(MMenu parent, Collection<MMenuElement> elements) {
        for (MMenuElement element : elements) {
            if (element.getWidget() == null) continue;
            this.hideChild(parent, (MUIElement)element);
        }
    }
}

