/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.langs.contrib;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.LanguageDef;
import org.eclipse.fx.code.editor.configuration.text.ConfigurationModelProvider;
import org.eclipse.fx.code.editor.services.URIProvider;
import org.eclipse.fx.core.URLUtils;
import org.eclipse.fx.core.log.LoggerCreator;
import org.osgi.service.component.annotations.Component;

@Component
public class LangsConfigurationModelProvider
implements ConfigurationModelProvider {
    private final List<Function<Input<?>, URL>> urlList = new ArrayList();
    private final Map<URL, LanguageDef> definitionCache = new HashMap<URL, LanguageDef>();

    public static String suffix(Input<?> input) {
        String uri = ((URIProvider)input).getURI();
        String[] parts = uri.split("/");
        String lastSegment = parts[parts.length - 1];
        int idx = lastSegment.lastIndexOf(46);
        if (idx != -1) {
            return lastSegment.substring(idx + 1);
        }
        return null;
    }

    public LangsConfigurationModelProvider() {
        LangsConfigurationModelProvider.prefix("adoc", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/adoc.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("ceylon", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/ceylon.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("dart", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/dart.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("go", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/go.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("groovy", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/groovy.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.javaSupport().ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("js", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/js.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("kotlin", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/kotlin.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("lua", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/lua.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("php", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/php.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("py", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/py.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("rust", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/rust.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("swift", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/swift.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("ts", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/ts.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("xml", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/xml.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("html", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/xml.json").ifPresent(this.urlList::add);
        LangsConfigurationModelProvider.prefix("sh", "platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/sh.json").ifPresent(this.urlList::add);
    }

    private static final Optional<Function<Input<?>, URL>> prefix(String prefix, String url) {
        return URLUtils.createUrl((String)url, (boolean)true).map(u -> new SuffixFunction(prefix, (URL)u));
    }

    private static final Optional<Function<Input<?>, URL>> javaSupport() {
        Optional javaBase = URLUtils.createUrl((String)"platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/java.json", (boolean)true);
        Optional moduleInfo = URLUtils.createUrl((String)"platform:/plugin/org.eclipse.fx.code.editor.langs/org/eclipse/fx/code/editor/ldef/langs/jmod.json", (boolean)true);
        if (!javaBase.isPresent() || !moduleInfo.isPresent()) {
            return null;
        }
        return Optional.of(input -> {
            if (input instanceof URIProvider && "java".equals(LangsConfigurationModelProvider.suffix(input))) {
                String uri = ((URIProvider)input).getURI();
                String[] parts = uri.split("/");
                String lastSegment = parts[parts.length - 1];
                if ("module-info.java".equals(lastSegment)) {
                    return (URL)moduleInfo.get();
                }
                return (URL)javaBase.get();
            }
            return null;
        });
    }

    public boolean applies(Input<?> input) {
        return this.urlList.stream().map(e -> (URL)e.apply(input)).filter(e -> e != null).findFirst().isPresent();
    }

    public LanguageDef getModel(Input<?> input) {
        return this.urlList.stream().map(e -> (URL)e.apply(input)).filter(e -> e != null).findFirst().map(this::getModelByExtension).orElse(null);
    }

    public LanguageDef getModelByExtension(URL url) {
        return this.definitionCache.computeIfAbsent(url, e -> {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    LanguageDef languageDef;
                    InputStreamReader r;
                    InputStream in;
                    block18: {
                        block17: {
                            in = url.openStream();
                            r = new InputStreamReader(in);
                            languageDef = (LanguageDef)EditorGModel.create().createObject((Reader)r);
                            if (r == null) break block17;
                            r.close();
                        }
                        if (in == null) break block18;
                        in.close();
                    }
                    return languageDef;
                    {
                        catch (Throwable throwable2) {
                            try {
                                if (r != null) {
                                    r.close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (in != null) {
                                    in.close();
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e1) {
                LoggerCreator.createLogger(LangsConfigurationModelProvider.class).error("Unable to load json file '" + String.valueOf(url) + "'", (Throwable)e1);
                return null;
            }
        });
    }

    static class SuffixFunction
    implements Function<Input<?>, URL> {
        private final String suffix;
        private final URL url;

        public SuffixFunction(String suffix, URL url) {
            this.suffix = suffix;
            this.url = url;
        }

        @Override
        public URL apply(Input<?> input) {
            if (input instanceof URIProvider && this.suffix.equals(LangsConfigurationModelProvider.suffix(input))) {
                return this.url;
            }
            return null;
        }
    }
}

