/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.advanced;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.bidi.StructuredTextProcessor;
import org.eclipse.equinox.bidi.StructuredTextTypeHandlerFactory;
import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.advanced.StructuredTextEnvironment;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;
import org.eclipse.equinox.bidi.internal.StructuredTextImpl;

public final class StructuredTextExpertFactory {
    private static final String defaultSeparators = StructuredTextProcessor.getDefaultSeparators();
    private static Map sharedDefaultExperts = new HashMap();
    private static Map sharedExperts = new HashMap();
    private static IStructuredTextExpert defaultExpert;

    private StructuredTextExpertFactory() {
    }

    public static IStructuredTextExpert getExpert() {
        if (defaultExpert == null) {
            StructuredTextTypeHandler handler = new StructuredTextTypeHandler(defaultSeparators);
            defaultExpert = new StructuredTextImpl(handler, StructuredTextEnvironment.DEFAULT, false);
        }
        return defaultExpert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStructuredTextExpert getExpert(String type) {
        IStructuredTextExpert expert;
        Map map = sharedDefaultExperts;
        synchronized (map) {
            expert = (IStructuredTextExpert)sharedDefaultExperts.get(type);
            if (expert == null) {
                StructuredTextTypeHandler handler = StructuredTextTypeHandlerFactory.getHandler(type);
                if (handler == null) {
                    throw new IllegalArgumentException("Invalid type argument");
                }
                expert = new StructuredTextImpl(handler, StructuredTextEnvironment.DEFAULT, false);
                sharedDefaultExperts.put(type, expert);
            }
        }
        return expert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IStructuredTextExpert getExpert(String type, StructuredTextEnvironment environment) {
        IStructuredTextExpert expert;
        if (environment == null) {
            environment = StructuredTextEnvironment.DEFAULT;
        }
        Map map = sharedExperts;
        synchronized (map) {
            HashMap<String, IStructuredTextExpert> experts = (HashMap<String, IStructuredTextExpert>)sharedExperts.get(type);
            if (experts == null) {
                experts = new HashMap<String, IStructuredTextExpert>();
                sharedExperts.put(type, experts);
            }
            if ((expert = (IStructuredTextExpert)experts.get(environment)) == null) {
                StructuredTextTypeHandler handler = StructuredTextTypeHandlerFactory.getHandler(type);
                if (handler == null) {
                    throw new IllegalArgumentException("Invalid type argument");
                }
                expert = new StructuredTextImpl(handler, environment, false);
                experts.put(type, expert);
            }
        }
        return expert;
    }

    public static IStructuredTextExpert getStatefulExpert(String type) {
        return StructuredTextExpertFactory.getStatefulExpert(type, StructuredTextEnvironment.DEFAULT);
    }

    public static IStructuredTextExpert getStatefulExpert(String type, StructuredTextEnvironment environment) {
        StructuredTextTypeHandler handler = StructuredTextTypeHandlerFactory.getHandler(type);
        if (handler == null) {
            throw new IllegalArgumentException("Invalid type argument");
        }
        return StructuredTextExpertFactory.getStatefulExpert(handler, environment);
    }

    public static IStructuredTextExpert getStatefulExpert(StructuredTextTypeHandler handler, StructuredTextEnvironment environment) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        if (environment == null) {
            environment = StructuredTextEnvironment.DEFAULT;
        }
        return new StructuredTextImpl(handler, environment, true);
    }
}

