/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

public abstract class AbstractElementFinder {
    public List<Assignment> findAssignments(AbstractRule ... calledRules) {
        return this.findByNestedRuleCall(Assignment.class, calledRules);
    }

    protected <T> List<T> findByNestedRuleCall(Class<T> clazz, AbstractRule ... rule) {
        HashSet<AbstractRule> rls = new HashSet<AbstractRule>(Arrays.asList(rule));
        ArrayList<EObject> r = new ArrayList<EObject>();
        for (AbstractRule abstractRule : this.getRules()) {
            TreeIterator i = abstractRule.eAllContents();
            while (i.hasNext()) {
                EObject o = (EObject)i.next();
                if (!clazz.isInstance(o)) continue;
                TreeIterator ct = o.eAllContents();
                while (ct.hasNext()) {
                    EObject cto = (EObject)ct.next();
                    if (!(cto instanceof RuleCall) || !rls.contains(((RuleCall)cto).getRule())) continue;
                    r.add(o);
                    break;
                }
                i.prune();
            }
        }
        return r;
    }

    public List<CrossReference> findCrossReferences(AbstractRule ... rule) {
        return this.findByNestedRuleCall(CrossReference.class, rule);
    }

    public List<CrossReference> findCrossReferences(EClassifier ... targetEClassifiers) {
        HashSet<EClassifier> classifiers = new HashSet<EClassifier>(Arrays.asList(targetEClassifiers));
        ArrayList classes = Lists.newArrayList((Iterable)Iterables.filter(classifiers, EClass.class));
        ArrayList<CrossReference> r = new ArrayList<CrossReference>();
        for (AbstractRule abstractRule : this.getRules()) {
            TreeIterator i = abstractRule.eAllContents();
            while (i.hasNext()) {
                EObject o = (EObject)i.next();
                if (!(o instanceof CrossReference)) continue;
                CrossReference c = (CrossReference)o;
                if (classifiers.contains(c.getType().getClassifier())) {
                    r.add(c);
                } else if (c.getType().getClassifier() instanceof EClass) {
                    for (EClass cls : classes) {
                        if (!EcoreUtil2.isAssignableFrom(cls, (EClass)c.getType().getClassifier())) continue;
                        r.add(c);
                        break;
                    }
                }
                i.prune();
            }
        }
        return r;
    }

    public List<Pair<Keyword, Keyword>> findKeywordPairs(String leftKw, String rightKw) {
        ArrayList<Pair<Keyword, Keyword>> pairs = new ArrayList<Pair<Keyword, Keyword>>();
        for (AbstractRule abstractRule : this.getRules()) {
            if (!(abstractRule instanceof ParserRule) || GrammarUtil.isDatatypeRule((ParserRule)abstractRule)) continue;
            Stack<Keyword> openings = new Stack<Keyword>();
            TreeIterator i = abstractRule.eAllContents();
            while (i.hasNext()) {
                EObject o = (EObject)i.next();
                if (!(o instanceof Keyword)) continue;
                Keyword k = (Keyword)o;
                if (leftKw.equals(k.getValue())) {
                    openings.push(k);
                    continue;
                }
                if (!rightKw.equals(k.getValue()) || openings.size() <= 0) continue;
                pairs.add((Pair<Keyword, Keyword>)Tuples.create((Object)((Keyword)openings.pop()), (Object)k));
            }
        }
        return pairs;
    }

    public List<Keyword> findKeywords(String ... keywords) {
        HashSet<String> kwds = new HashSet<String>(Arrays.asList(keywords));
        ArrayList<Keyword> r = new ArrayList<Keyword>();
        for (AbstractRule abstractRule : this.getRules()) {
            TreeIterator i = abstractRule.eAllContents();
            while (i.hasNext()) {
                Keyword k;
                EObject o = (EObject)i.next();
                if (!(o instanceof Keyword) || !kwds.contains((k = (Keyword)o).getValue())) continue;
                r.add(k);
            }
        }
        return r;
    }

    public List<RuleCall> findRuleCalls(AbstractRule ... rules) {
        HashSet<AbstractRule> rls = new HashSet<AbstractRule>(Arrays.asList(rules));
        ArrayList<RuleCall> r = new ArrayList<RuleCall>();
        for (AbstractRule abstractRule : this.getRules()) {
            TreeIterator i = abstractRule.eAllContents();
            while (i.hasNext()) {
                RuleCall c;
                EObject o = (EObject)i.next();
                if (!(o instanceof RuleCall) || !rls.contains((c = (RuleCall)o).getRule())) continue;
                r.add(c);
            }
        }
        return r;
    }

    protected abstract Iterable<? extends AbstractRule> getRules();

    public static abstract class AbstractParserRuleElementFinder
    extends AbstractElementFinder
    implements IGrammarAccess.IParserRuleAccess {
        @Override
        protected Iterable<? extends AbstractRule> getRules() {
            return Collections.singletonList(this.getRule());
        }
    }

    public static abstract class AbstractGrammarElementFinder
    extends AbstractElementFinder
    implements IGrammarAccess {
        @Override
        protected Iterable<? extends AbstractRule> getRules() {
            return GrammarUtil.allRules(this.getGrammar());
        }
    }

    public static abstract class AbstractEnumRuleElementFinder
    extends AbstractElementFinder
    implements IGrammarAccess.IEnumRuleAccess {
        @Override
        protected Iterable<? extends AbstractRule> getRules() {
            return Collections.singletonList(this.getRule());
        }
    }
}

