/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.client.handler;

import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import servlet.tck.common.client.handler.Handler;
import servlet.tck.common.request.Header;

public class ALLOWHandler
implements Handler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ALLOWHandler.class);
    private static final Handler HANDLER = new ALLOWHandler();

    private ALLOWHandler() {
    }

    public static Handler getInstance() {
        return HANDLER;
    }

    @Override
    public boolean invoke(Header configuredHeader, Header responseHeader) {
        String ALLOWHeader = responseHeader.getValue().toLowerCase();
        String expectedValues = configuredHeader.getValue().toLowerCase().replace(" ", "");
        LOGGER.trace("[ALLOWHandler] ALLOW header received: {}", (Object)ALLOWHeader);
        StringTokenizer conf = new StringTokenizer(expectedValues, ",");
        while (conf.hasMoreTokens()) {
            String token;
            String token1 = token = conf.nextToken();
            if (!ALLOWHeader.contains(token) && !ALLOWHeader.contains(token1)) {
                LOGGER.error("[ALLOWHandler] Unable to find '{}' within the ALLOW header returned by the server.", (Object)token);
                return false;
            }
            LOGGER.trace("[ALLOWHandler] Found expected value, '{}' in ALLOW header returned by server.", (Object)token);
        }
        return true;
    }
}

