/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/common/taglibsig/validation/ValidatorFactory.java $ $LastChangedDate: 2011-04-20 13:07:16 -0700 (Wed, 20 Apr 2011) $
 */
 
package com.sun.ts.tests.common.taglibsig.validation;

import com.sun.ts.lib.util.TestUtil;

public class ValidatorFactory {

    // No instances of Factory
    private ValidatorFactory() {
    }

    /**
     * <p>Returns an instance of a {@link Validator} based on
     * the provided class name.</p>
     * @param className - The name of the Validator's implementation class
     * @return a Validator instance of the class exists, otherwise null
     */
    public static Validator getValidator(String className) {
        Validator v = null;
        try {
            v = (Validator)
                Thread.currentThread().getContextClassLoader().
                    loadClass(className).newInstance();
        } catch (Throwable t) {
            //XXX Enhance this section
            System.out.println(t.toString());
            TestUtil.logMsg(t.toString());
        }
        return v;
    }
}
