/*
* Copyright (c) 2009 Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/


package com.sun.ts.tests.common.connector.whitebox.ibanno;

import java.lang.reflect.Method;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.work.Work;
import com.sun.ts.tests.common.connector.util.TSMessageListenerInterface;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.util.AppException;
import com.sun.ts.tests.common.connector.whitebox.*;



public class IBAnnoMessageWork2 implements Work {

    private String name;
    private boolean stop = false;
    private MessageEndpointFactory factory;
    private LocalTxMessageXAResource msgxa = new LocalTxMessageXAResource("LocalTxMessageXAResource2");
    
    public IBAnnoMessageWork2(String name, MessageEndpointFactory factory) {
        this.factory = factory;
        this.name = name;
        System.out.println("IBAnnoMessageWork2.constructor");
    }

    public void run() {

        while (!stop) {
            try {
                
                //creating xaep to check if the message delivery is transacted.
                MessageEndpoint xaep = factory.createEndpoint(msgxa);
                MessageEndpoint xaep1 = factory.createEndpoint(msgxa);
                MessageEndpoint xaep2 = factory.createEndpoint(msgxa);

                Method onMessagexa = getOnMessageMethod();
                ((TSMessageListenerInterface) xaep).onMessage("IBAnnoMessageWork2 MDB2 Transacted Message1");
                ((TSMessageListenerInterface) xaep1).onMessage("IBAnnoMessageWork2 MDB2 Transacted Message2");
                ((TSMessageListenerInterface) xaep2).onMessage("IBAnnoMessageWork2 MDB2 Transacted Message3");

                Debug.trace("IBAnnoMessageWork2 MDB2 Transacted Message1");
                Debug.trace("IBAnnoMessageWork2 MDB2 Transacted Message2");
                Debug.trace("IBAnnoMessageWork2 MDB2 Transacted Message3");

                break;
            } catch (AppException ex) {
                 ex.printStackTrace(); 
            }
            catch (UnavailableException ex) {
                try 
                {
                    Thread.currentThread().sleep(3000);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        
    }

    public Method getOnMessageMethod() {

        Method onMessageMethod = null;
        try {
            Class msgListenerClass = TSMessageListenerInterface.class;
            Class[] paramTypes = { java.lang.String.class };
            onMessageMethod =
                msgListenerClass.getMethod("onMessage", paramTypes);

        } catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return onMessageMethod;
    }
 
    public void release() {}

    public void stop() {
        this.stop = true;
    }

    public String toString() {
       return name;
    }

}
