/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: JAXRDeliverable.java 62564 2011-04-18 20:29:25Z kgrucci $
 */

package com.sun.ts.lib.deliverable.jaxrpc;

import com.sun.ts.lib.deliverable.*;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.DeploymentInfo;
import com.sun.javatest.*;
import java.util.*;
import java.io.*;

/**
 * This class serves as a place for JAXR Deliverable specific info.
 *
 * @author    Kyle Grucci
 */
public class JAXRPCDeliverable extends AbstractDeliverable
{
        
    public PropertyManagerInterface createPropertyManager(TestEnvironment te) throws Exception {
            return JAXRPCPropertyManager.getJAXRPCPropertyManager(te);
    }

    public PropertyManagerInterface createPropertyManager(Properties p) throws Exception {
        return JAXRPCPropertyManager.getJAXRPCPropertyManager(p);
    }

    public PropertyManagerInterface getPropertyManager() throws Exception {
        return JAXRPCPropertyManager.getJAXRPCPropertyManager();
    }

    public Map getValidVehicles() {
        super.getValidVehicles();
	//add default values
	htTSValidVehicles.put("tests.service_eetest.vehicles", new String[]{"standalone"}); 
        return htTSValidVehicles;
    }

    public boolean supportsAutoDeployment() {
        return false;
    }
}
