/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.migration.twothree;

import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.common.migration.twothree.TwoLocalIF;
import com.sun.ts.tests.ejb30.common.migration.twothree.TwoRemoteIF;
import jakarta.ejb.CreateException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class TwoTestBean
implements SessionBean {
    public static final String TWO_LOCAL_SHORT = "ejb/twolocal";
    public static final String TWO_LOCAL = "java:comp/env/ejb/twolocal";
    public static final String TWO_REMOTE_SHORT = "ejb/tworemote";
    public static final String TWO_REMOTE = "java:comp/env/ejb/tworemote";
    private SessionContext sessionContext;

    public void ejbCreate() throws CreateException {
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public void ejbRemove() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void callRemote() throws TestFailedException {
        TwoRemoteIF twoRemote = null;
        try {
            twoRemote = this.getTwoRemoteBean();
            String result = twoRemote.from2RemoteClient();
            if (!"from2RemoteClient".equals(result)) {
                throw new TestFailedException("Expected from2RemoteClient() to returnfrom2RemoteClient, but actual '" + result + "'");
            }
        }
        catch (RemoteException e) {
            throw new TestFailedException(e);
        }
    }

    public void callRemoteSameTxContext() throws TestFailedException {
        TwoRemoteIF twoRemote = null;
        try {
            twoRemote = this.getTwoRemoteBean();
            twoRemote.remoteSameTxContext();
            if (!this.sessionContext.getRollbackOnly()) {
                throw new TestFailedException("Expected getRollbackOnly to return true, but got false.");
            }
        }
        catch (RemoteException e) {
            throw new TestFailedException(e);
        }
    }

    public void callLocal() throws TestFailedException {
        TwoLocalIF twoLocal = this.getTwoLocalBean();
        String result = twoLocal.from2LocalClient();
        if (!"from2LocalClient".equals(result)) {
            throw new TestFailedException("Expected from2LocalClient() to returnfrom2LocalClient, but actual '" + result + "'");
        }
    }

    public void callLocalSameTxContext() throws TestFailedException {
        TwoLocalIF twoLocal = null;
        twoLocal = this.getTwoLocalBean();
        twoLocal.localSameTxContext();
        if (!this.sessionContext.getRollbackOnly()) {
            throw new TestFailedException("Expected getRollbackOnly to return true, but got false.");
        }
    }

    protected TwoRemoteIF getTwoRemoteBean() throws TestFailedException {
        TwoRemoteIF twoRemote = null;
        try {
            Object obj = this.sessionContext.lookup(TWO_REMOTE_SHORT);
            twoRemote = (TwoRemoteIF)obj;
        }
        catch (Exception e) {
            throw new TestFailedException(e);
        }
        return twoRemote;
    }

    protected TwoRemoteIF getTwoRemoteBeanJndi() throws TestFailedException {
        TwoRemoteIF twoRemote = null;
        try {
            InitialContext ic = new InitialContext();
            Object obj = ic.lookup(TWO_REMOTE);
            twoRemote = (TwoRemoteIF)PortableRemoteObject.narrow((Object)obj, TwoRemoteIF.class);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
        catch (Exception e) {
            throw new TestFailedException(e);
        }
        return twoRemote;
    }

    protected TwoLocalIF getTwoLocalBean() throws TestFailedException {
        TwoLocalIF twoLocal = null;
        try {
            Object obj = this.sessionContext.lookup(TWO_LOCAL_SHORT);
            twoLocal = (TwoLocalIF)obj;
        }
        catch (Exception e) {
            throw new TestFailedException(e);
        }
        return twoLocal;
    }

    protected TwoLocalIF getTwoLocalBeanJndi() throws TestFailedException {
        TwoLocalIF twoLocal = null;
        try {
            InitialContext ic = new InitialContext();
            twoLocal = (TwoLocalIF)ic.lookup(TWO_LOCAL);
        }
        catch (NamingException e) {
            throw new TestFailedException(e);
        }
        return twoLocal;
    }
}

