/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.audit.AuditTool;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolManager;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;

public class AuditToolManager
extends ToolManager {
    private AuditTool tool;

    public AuditToolManager(Desktop desktop) {
        super(desktop);
    }

    @Override
    public Action[] getWindowOpenMenuActions() {
        ToolAction a = new ToolAction(this.i18n, "tmgr.openAudit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuditToolManager.this.startTool();
            }
        };
        return new Action[]{a};
    }

    @Override
    public Tool startTool() {
        AuditTool t = this.getTool();
        Desktop d = this.getDesktop();
        if (!d.containsTool(t)) {
            d.addTool(t);
        }
        d.setSelectedTool(t);
        return t;
    }

    @Override
    public Tool restoreTool(Map<String, String> m) {
        AuditTool t = this.getTool();
        t.restore(m);
        return t;
    }

    AuditTool getTool() {
        if (this.tool == null) {
            this.tool = new AuditTool(this);
            this.tool.addObserver(new Tool.Observer(){

                @Override
                public void shortTitleChanged(Tool t, String newValue) {
                }

                @Override
                public void titleChanged(Tool t, String newValue) {
                }

                @Override
                public void toolDisposed(Tool t) {
                    if (t == AuditToolManager.this.tool) {
                        AuditToolManager.this.tool = null;
                    }
                }
            });
        }
        return this.tool;
    }
}

