/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.xa.ee.xresXcomp2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.xa.ee.xresXcomp2.Ejb2Test;
import jakarta.ejb.EJBException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;

public class Ejb1TestEJB {
    private Properties p = null;
    private Properties testProps = null;
    private Integer dbSize1;
    private String dbTable1 = null;
    private Ejb2Test ref = null;
    private TSNamingContext context = null;
    private transient PreparedStatement pStmt;
    private DataSource ds1;
    private DataSource ds4 = null;
    private transient Connection con1 = null;
    private transient Connection con4 = null;
    private TSEISDataSource ds2;
    private TSEISDataSource ds3;
    private TSEISDataSource ds5;
    private transient TSConnection con2 = null;
    private transient TSConnection con3 = null;
    private transient TSConnection con5 = null;
    private transient Statement stmt = null;

    public void initialize(Properties props) {
        this.testProps = props;
        String eMsg = "";
        try {
            TestUtil.init((Properties)props);
            this.context = new TSNamingContext();
            eMsg = "Exception doing a lookup for Ejb2Test ";
            this.ref = (Ejb2Test)this.context.lookup("java:comp/env/ejb/Ejb2Test", Ejb2Test.class);
            this.ref.initialize(props);
            TestUtil.logMsg((String)"Initialize logging data from server in Ejb1");
            eMsg = "Exception doing a initLogging for Ejb2Test ";
            this.ref.initLogging(this.p);
            eMsg = "Exception looking up size";
            this.dbSize1 = (Integer)this.context.lookup("java:comp/env/size");
            eMsg = "Exception looking up JDBCwhitebox";
            this.ds1 = (DataSource)this.context.lookup("java:comp/env/eis/JDBCwhitebox-xa");
            eMsg = "Exception looking up EIS whitebox-xa";
            this.ds2 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-xa");
            eMsg = "Exception looking up EIS whitebox-tx";
            this.ds3 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-tx");
            eMsg = "Exception looking up JDBCwhitebox-tx";
            this.ds4 = (DataSource)this.context.lookup("java:comp/env/eis/JDBCwhitebox-tx");
            eMsg = "Exception looking up whitebox-notx";
            this.ds5 = (TSEISDataSource)this.context.lookup("java:comp/env/eis/whitebox-notx");
            TestUtil.logMsg((String)("JDBCwhitebox-xa ds1 : " + String.valueOf(this.ds1)));
            TestUtil.logMsg((String)("whitebox-xa ds2 : " + String.valueOf(this.ds2)));
            TestUtil.logMsg((String)("whitebox-tx ds3 : " + String.valueOf(this.ds3)));
            TestUtil.logMsg((String)("JDBCwhitebox-tx ds4 : " + String.valueOf(this.ds4)));
            TestUtil.logMsg((String)("whitebox-notx ds5 : " + String.valueOf(this.ds5)));
        }
        catch (Exception e) {
            TestUtil.logMsg((String)eMsg);
            TestUtil.logErr((String)"Ejb1: initialize failed", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void dbConnect(String tName) {
        TestUtil.logMsg((String)"dbConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.conTable1();
                TestUtil.logMsg((String)("Made the JDBC connection to " + this.dbTable1 + " DB"));
            } else {
                this.conTable2();
                TestUtil.logMsg((String)"Made the connection to EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception on connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void txDbConnect(String tName) {
        TestUtil.logMsg((String)"txDbConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.conTable4();
                TestUtil.logMsg((String)("Made the JDBC TX connection to " + this.dbTable1 + " DB"));
            } else {
                this.conTable3();
                TestUtil.logMsg((String)"Made the EIS TX connection to EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception on connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void createData(String tName) {
        TestUtil.logTrace((String)"createData");
        try {
            if (tName.equals(this.dbTable1)) {
                this.createTable1();
                TestUtil.logMsg((String)("Created the table " + this.dbTable1 + " "));
            } else {
                this.createTable2();
                TestUtil.logMsg((String)"Created the EIS data");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception creating table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void insertDup(String tName, String tSize) {
        String eMsg = null;
        TestUtil.logTrace((String)"insertDup");
        String key = tSize;
        try {
            if (tName.equals(this.dbTable1)) {
            } else {
                TestUtil.logMsg((String)"Getting a connection con5");
                eMsg = "Exception doing a getConnection from ds5";
                this.con5 = this.ds5.getConnection();
                TestUtil.logTrace((String)("con5: " + this.con5.toString()));
                TestUtil.logMsg((String)"Insert row in EIS");
                eMsg = "Exception doing an insert in EIS con5 ds5";
                this.con5.insert(key, key);
                TestUtil.logTrace((String)"Inserted a row in EIS using notx - key ");
                TestUtil.logMsg((String)"nsertDup key in EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg(eMsg);
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)"Captured Exception in insertDup");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                eMsg = "Exception in closing con5";
                if (this.con5 != null) {
                    this.con5.close();
                    this.con5 = null;
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)eMsg);
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logMsg((String)"Captured Exception in insertDup");
                throw new EJBException(e.getMessage());
            }
        }
    }

    public boolean insert(String tName, int key) {
        TestUtil.logTrace((String)"insert");
        String newName = null;
        try {
            if (tName.equals(this.dbTable1)) {
                newName = this.dbTable1 + "-" + key;
                String updateString = TestUtil.getProperty((String)"Xa_Tab1_Insert");
                this.pStmt = this.con1.prepareStatement(updateString);
                this.pStmt.setInt(1, key);
                this.pStmt.setString(2, newName);
                this.pStmt.setString(3, newName);
                TestUtil.logMsg((String)("Insert a row into the table " + tName + " valus : " + key));
                this.pStmt.executeUpdate();
                this.pStmt.close();
                TestUtil.logTrace((String)"Inserting a row into the EIS ");
                this.ref.dbConnect("EIS");
                this.ref.insert("EIS", key);
                this.ref.dbUnConnect("EIS");
            } else {
                this.con2.insert(new Integer(key).toString(), new Integer(key).toString());
                TestUtil.logMsg((String)"Inserted a row into the EIS ");
                TestUtil.logMsg((String)("Inserting a row into the table " + this.dbTable1));
                this.ref.dbConnect(this.dbTable1);
                this.ref.insert(this.dbTable1, key);
                this.ref.dbUnConnect(this.dbTable1);
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception inserting a row into table " + tName + ";\n" + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void delete(String tName, int fromKey, int toKey) {
        TestUtil.logTrace((String)"delete");
        try {
            if (tName.equals(this.dbTable1)) {
                String updateString = TestUtil.getProperty((String)"Xa_Tab1_Delete1");
                this.pStmt = this.con1.prepareStatement(updateString);
                for (int i = fromKey; i <= toKey; ++i) {
                    this.pStmt.setInt(1, i);
                    this.pStmt.executeUpdate();
                }
                this.pStmt.close();
                TestUtil.logMsg((String)("Deleted row(s) " + fromKey + " thru " + toKey + " from the table " + tName));
            } else {
                for (int i = fromKey; i <= toKey; ++i) {
                    this.con2.delete(new Integer(i).toString());
                }
                TestUtil.logMsg((String)("Deleted row(s) from EIS " + fromKey + " thru " + toKey));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception deleting row(s) " + fromKey + " thru " + toKey + " from the table " + tName), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public Vector getResults(String tName) {
        TestUtil.logTrace((String)"getResults");
        ResultSet rs = null;
        Vector queryResults = new Vector();
        Object name = null;
        try {
            if (tName.equals(this.dbTable1)) {
                String query = TestUtil.getProperty((String)"Xa_Tab1_query");
                this.stmt = this.con4.createStatement();
                rs = this.stmt.executeQuery(query);
                if (rs != null) {
                    while (rs.next()) {
                        int i = rs.getInt(1);
                        queryResults.addElement(new Integer(i));
                    }
                }
                this.stmt.close();
                TestUtil.logMsg((String)("Obtained " + tName + " table ResultSet"));
            } else {
                queryResults = this.con3.readData();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception obtaining " + tName + " table ResultSet"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        return queryResults;
    }

    public void destroyData(String tName) {
        String eMsg = null;
        String removeString = TestUtil.getProperty((String)"Xa_Tab1_Delete");
        TestUtil.logMsg((String)("destroyData : " + tName));
        try {
            if (tName.equals(this.dbTable1)) {
                eMsg = "Exception doing a dropTable on con4";
                this.stmt = this.con4.createStatement();
                this.stmt.executeUpdate(removeString);
                TestUtil.logMsg((String)("Deleted all rows from table " + this.dbTable1));
            } else {
                eMsg = "Exception doing a dropTable on con3";
                this.con3.dropTable();
                TestUtil.logMsg((String)"Deleted all rows from EIS");
            }
        }
        catch (Exception e) {
            TestUtil.logMsg(eMsg);
            TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                eMsg = "Exception in closing stmt";
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
            }
            catch (Exception e) {
                TestUtil.logMsg((String)eMsg);
                TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
                throw new EJBException(e.getMessage());
            }
        }
    }

    public void dbUnConnect(String tName) {
        TestUtil.logMsg((String)"dbUnConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.con1.close();
                this.con1 = null;
                TestUtil.logMsg((String)("Closed " + this.dbTable1 + " connection"));
            } else {
                this.con2.close();
                this.con2 = null;
                TestUtil.logMsg((String)"Closed EIS connection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to close the DB connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void txDbUnConnect(String tName) {
        TestUtil.logMsg((String)"txDbUnConnect");
        try {
            if (tName.equals(this.dbTable1)) {
                this.con4.close();
                this.con4 = null;
                TestUtil.logMsg((String)("Closed " + this.dbTable1 + " connection"));
            } else {
                this.con3.close();
                this.con3 = null;
                TestUtil.logMsg((String)"Closed EIS connection");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to close the DB connection", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging Ejb1");
        this.testProps = p;
        try {
            TestUtil.init((Properties)p);
            this.dbTable1 = TestUtil.getTableName((String)TestUtil.getProperty((String)"Xa_Tab1_Delete"));
            TestUtil.logMsg((String)(this.dbTable1 + " Ejb1 initLogging OK!"));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Inside Ejb1 initLogging" + e.getMessage());
        }
    }

    public void throwEJBException() throws EJBException {
        TestUtil.logTrace((String)"throwEJBException");
        throw new EJBException("EJBException from Ejb1TestEJB");
    }

    private void conTable1() {
        TestUtil.logTrace((String)"conTable1");
        try {
            this.con1 = this.ds1.getConnection();
            TestUtil.logTrace((String)("con1: " + this.con1.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable1 + " DB con1 "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable1 + " DB con1 "), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        try {
            this.con2 = this.ds2.getConnection();
            TestUtil.logMsg((String)("con2: " + this.con2.toString()));
        }
        catch (Exception ee) {
            TestUtil.logErr((String)"Exception connecting to EIS con2 ", (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable3() {
        TestUtil.logTrace((String)"conTable3");
        try {
            this.con3 = this.ds3.getConnection();
            TestUtil.logTrace((String)("con3: " + this.con3.toString()));
        }
        catch (Exception ee) {
            TestUtil.logErr((String)"Exception connecting to EIS con3 ", (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void conTable4() {
        TestUtil.logTrace((String)"conTable4");
        try {
            this.con4 = this.ds4.getConnection();
            TestUtil.logTrace((String)("con4: " + this.con4.toString()));
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException connecting to " + this.dbTable1 + " DB con4 "), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
        catch (Exception ee) {
            TestUtil.logErr((String)("Exception connecting to " + this.dbTable1 + " DB con4 "), (Throwable)ee);
            throw new EJBException(ee.getMessage());
        }
    }

    private void createTable1() {
        TestUtil.logTrace((String)"createTable1");
        try {
            this.dropTable1();
            TestUtil.logTrace((String)("All rows deleted from table " + this.dbTable1));
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("SQLException encountered in createTable1: " + e.getMessage()));
        }
        try {
            TestUtil.logMsg((String)("Adding the " + this.dbTable1 + " table rows"));
            String updateString = TestUtil.getProperty((String)"Xa_Tab1_Insert");
            this.pStmt = this.con4.prepareStatement(updateString);
            for (int i = 1; i <= this.dbSize1; ++i) {
                int newKey = i;
                String newName = this.dbTable1 + "-" + i;
                this.pStmt.setInt(1, newKey);
                this.pStmt.setString(2, newName);
                this.pStmt.setString(3, newName);
                this.pStmt.executeUpdate();
            }
            this.pStmt.close();
        }
        catch (SQLException e) {
            TestUtil.logErr((String)("SQLException creating " + this.dbTable1 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void createTable2() {
        try {
            this.dropTable2();
            TestUtil.logTrace((String)"All rows deleted from EIS ");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("SQLException encountered in createTable2: " + e.getMessage()));
        }
        try {
            TestUtil.logMsg((String)"Adding the EIS rows");
            for (int i = 1; i <= this.dbSize1; ++i) {
                this.con3.insert(new Integer(i).toString(), new Integer(i).toString());
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("SQLException creating " + this.dbTable1 + " table"), (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void dropTable1() {
        TestUtil.logTrace((String)"dropTable1");
        String removeString = TestUtil.getProperty((String)"Xa_Tab1_Delete");
        try {
            this.stmt = this.con4.createStatement();
            this.stmt.executeUpdate(removeString);
            this.stmt.close();
        }
        catch (SQLException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void dropTable2() {
        TestUtil.logTrace((String)"dropTable2");
        try {
            this.con3.dropTable();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

