/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.strquery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Spouse;
import ee.jakarta.tck.persistence.common.schema30.Util;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Fetch;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class Client3
extends Util {
    public static void main(String[] args) {
        Client3 theTests = new Client3();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest2() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute findAllCustomers");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root c = cquery.from(Customer.class);
            cquery.select((Selection)c);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[this.customerRef.length];
            for (int i = 0; i < this.customerRef.length; ++i) {
                expectedPKs[i] = Integer.toString(i + 1);
            }
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected " + this.customerRef.length + " references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest2 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest4() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"3");
            this.logTrace("find Customer with Home Address in Swansea");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where(new Predicate[]{cbuilder.equal((Expression)customer.get("home").get("street"), (Expression)cbuilder.parameter(String.class, "street")), cbuilder.equal((Expression)customer.get("home").get("city"), (Expression)cbuilder.parameter(String.class, "city")), cbuilder.equal((Expression)customer.get("home").get("state"), (Expression)cbuilder.parameter(String.class, "state")), cbuilder.equal((Expression)customer.get("home").get("zip"), (Expression)cbuilder.parameter(String.class, "zip"))}).select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("street", (Object)"125 Moxy Lane").setParameter("city", (Object)"Swansea").setParameter("state", (Object)"MA").setParameter("zip", (Object)"11345");
            Customer c = (Customer)tquery.getSingleResult();
            if (expected.equals((Object)c)) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest4 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest6() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find Customers with Home Address Information");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.or(new Predicate[]{cbuilder.equal((Expression)customer.get("home").get("street"), (Expression)cbuilder.parameter(String.class, "street")), cbuilder.equal((Expression)customer.get("home").get("city"), (Expression)cbuilder.parameter(String.class, "city")), cbuilder.equal((Expression)customer.get("home").get("state"), (Expression)cbuilder.parameter(String.class, "state")), cbuilder.equal((Expression)customer.get("home").get("zip"), (Expression)cbuilder.parameter(String.class, "zip"))}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("street", (Object)"47 Skyline Drive");
            tquery.setParameter("city", (Object)"Chelmsford");
            tquery.setParameter("state", (Object)"VT");
            tquery.setParameter("zip", (Object)"02155");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "10", "11", "13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 4 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest6 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest15() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            Customer expected = (Customer)this.getEntityManager().find(Customer.class, (Object)"5");
            this.logTrace("find customer with name: Stephen S. D'Milla");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("name"), (Expression)cbuilder.parameter(String.class, "cName")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Stephen S. D'Milla");
            Customer c = (Customer)tquery.getSingleResult();
            if (expected.equals((Object)c)) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Did not get expected results.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest15 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest16() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers IN home city: Lexington");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").get("city").in(new Object[]{"Lexington"}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest16 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest17() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers NOT IN home city: Swansea or Brookline");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join h = customer.join("home", JoinType.LEFT);
            cquery.where((Expression)h.get("city").in(new Object[]{"Swansea", "Brookline"}).not());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "5", "6", "7", "8", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest17 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest18() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers with home ZIP CODE that ends in 77");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.like((Expression)customer.get("home").get("zip"), "%77"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest18 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest19() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers with a home zip code that does not contain 44 in the third and fourth position");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.notLike((Expression)customer.get("home").get("zip"), "%44_"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 15 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest19 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest22() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who have a null work zip code");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("work").get("zip").isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest22 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest23() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who do not have null work zip code entry");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("work").get("zip").isNotNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 17 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest23 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest36() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all customers who lives in city Attleboro");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").get("city").in(new Expression[]{cbuilder.parameter(String.class, "city")}));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("city", (Object)"Attleboro");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest36 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest37() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Execute two queries composed differently and verify results");
            CriteriaQuery cquery1 = cbuilder.createQuery(Customer.class);
            Root customer1 = cquery1.from(Customer.class);
            cquery1.where((Expression)customer1.get("home").get("state").in(new Object[]{"NH", "RI"})).select((Selection)customer1);
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            List clist1 = tquery1.getResultList();
            String[] expectedPKs = new String[]{"5", "6", "12", "14", "16"};
            CriteriaQuery cquery2 = cbuilder.createQuery(Customer.class);
            Root customer2 = cquery2.from(Customer.class);
            cquery2.where((Expression)cbuilder.or((Expression)cbuilder.equal((Expression)customer2.get("home").get("state"), (Object)"NH"), (Expression)cbuilder.equal((Expression)customer2.get("home").get("state"), (Object)"RI"))).select((Selection)customer2);
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            List clist2 = tquery2.getResultList();
            String[] expectedPKs2 = new String[]{"5", "6", "12", "14", "16"};
            if (!this.checkEntityPK(clist1, expectedPKs)) {
                this.logErr("Did not get expected results for first query.  Expected 5 reference, got: " + clist1.size());
            } else {
                this.logTrace("Expected results received for first query");
                pass1 = true;
            }
            if (!this.checkEntityPK(clist2, expectedPKs2)) {
                this.logErr("Did not get expected results for second query.  Expected 5 reference, got: " + clist2.size());
            } else {
                this.logTrace("Expected results received for second query");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest37 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest47() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip"))).select((Selection)customer.get("work").get("zip")).orderBy(new Order[]{cbuilder.asc((Expression)customer.get("work").get("zip"))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            this.logTrace("Compare results of work zip codes");
            pass = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest47 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest52() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.and((Expression)cbuilder.isNotNull((Expression)customer.get("country")), (Expression)cbuilder.equal((Expression)customer.get("name"), (Expression)cbuilder.parameter(String.class, "cName"))));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("cName", (Object)"Shelly D. McGowan");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"3"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest52 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest56() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        String[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find all work zip codes");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get("work").get("zip"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            if (clist.size() != 18) {
                this.logErr("Did not get expected results.  Expected 18 references, got: " + clist.size());
            } else {
                pass1 = true;
                int numOfNull = 0;
                int foundZip = 0;
                block2: for (String s : clist) {
                    this.logTrace("Check contents of List for null");
                    String o = s;
                    if (o == null) {
                        ++numOfNull;
                        continue;
                    }
                    this.logTrace("Check List for expected zip codes");
                    for (int l = 0; l < 17; ++l) {
                        if (!expectedZips[l].equals(o)) continue;
                        ++foundZip;
                        continue block2;
                    }
                }
                if (numOfNull != 1 || foundZip != 17) {
                    this.logErr("Did not get expected results");
                } else {
                    this.logTrace("Expected results received");
                    pass2 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest56 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest58() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find home zip codes");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("home").get("street"), (Object)"212 Edgewood Drive")).select((Selection)customer.get("name"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            Object s = tquery.getSingleResult();
            if (s != null) {
                this.logErr("Did not get expected results.  Expected null.");
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest58 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest59() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("determine which customers have an null name");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNull((Expression)customer.get("name")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"12"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest59 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest61() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            Join w = customer.join("work", JoinType.LEFT);
            cquery.where((Expression)cbuilder.isNull((Expression)w.get("zip")));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"13", "19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 3 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest61 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest64() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("work").get("city"), (Expression)cbuilder.parameter(String.class, "workcity")));
            cquery.select((Selection)cbuilder.construct(Customer.class, new Selection[]{customer.get("id"), customer.get("name")}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("workcity", (Object)"Burlington");
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 18 references, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest64 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest69() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        Long expectedResult1 = 17L;
        Long expectedResult2 = 16L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            CriteriaQuery cquery1 = cbuilder.createQuery(Long.class);
            Root customer1 = cquery1.from(Customer.class);
            cquery1.select((Selection)cbuilder.count((Expression)customer1.get("home").get("city")));
            TypedQuery tquery1 = this.getEntityManager().createQuery(cquery1);
            Long result1 = (Long)tquery1.getSingleResult();
            if (!result1.equals(expectedResult1)) {
                this.logErr("Query1 in queryTest69 returned:" + result1 + " expected: " + expectedResult1);
            } else {
                this.logTrace("pass:  Query1 in queryTest69 returned expected results");
                pass1 = true;
            }
            CriteriaQuery cquery2 = cbuilder.createQuery(Long.class);
            Root customer2 = cquery2.from(Customer.class);
            cquery2.select((Selection)cbuilder.countDistinct((Expression)customer2.get("home").get("city")));
            TypedQuery tquery2 = this.getEntityManager().createQuery(cquery2);
            Long result2 = (Long)tquery2.getSingleResult();
            if (!result2.equals(expectedResult2)) {
                this.logErr("Query 2 in queryTest69 returned:" + result2 + " expected: " + expectedResult2);
            } else {
                this.logTrace("pass:  Query 2 in queryTest69 returned expected results");
                pass2 = true;
            }
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryTest69 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void queryTest71() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Check if a spouse is related to a customer");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root spouse = cquery.from(Spouse.class);
            cquery.where((Expression)cbuilder.equal((Expression)spouse.get("id"), (Object)"7")).select((Selection)spouse.get("customer"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.getSingleResult();
            this.getEntityTransaction().commit();
        }
        catch (NoResultException e) {
            this.logTrace("queryTest71: NoResultException caught as expected : " + String.valueOf((Object)e));
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("queryTest71 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupBy() throws Exception {
        boolean pass = false;
        Object[] expectedCodes = new String[]{"CHA", "GBR", "IRE", "JPN", "USA"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get("country").get("code"));
            cquery.groupBy(new Expression[]{customer.get("country").get("code")});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCodes, output);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 4 Country Codes: CHA, GBR, JPN, USA. Received: " + result.size());
                for (String s : result) {
                    this.logErr(" Credit Card Type: " + s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_groupBy failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_innerjoin_1x1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.join("spouse");
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_innerjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_fetchjoin_1x1() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch("spouse");
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results. Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_1x1 failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_fetchjoin_1xM() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").get("state").in(new Object[]{"NY", "RI"}));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"14", "17"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 2 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_fetchjoin_1xM failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_groupByHaving() throws Exception {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.groupBy(new Expression[]{customer.get("country").get("code")}).having((Expression)customer.get("country").get("code").in(new Object[]{"GBR", "CHA"})).select((Selection)cbuilder.count((Expression)customer));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            int numOfExpected = 0;
            this.logTrace("Check result received . . . ");
            for (Long l : result) {
                if (!l.equals(expectedGBR) && !l.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected != 2) {
                this.logErr("Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size());
                for (Long l : result) {
                    this.logTrace("count of Codes Returned: " + l);
                }
            } else {
                this.logTrace("Expected results received.");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_groupByHaving failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_concatHavingClause() throws Exception {
        boolean pass = false;
        String expectedCustomer = "Margaret Mills";
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer.get("name")).groupBy(new Expression[]{customer.get("name")}).having((Expression)cbuilder.equal((Expression)customer.get("name"), cbuilder.concat("Margaret ", (Expression)cbuilder.parameter(String.class, "lname"))));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("lname", (Object)"Mills");
            String result = (String)tquery.getSingleResult();
            if (result.equals("Margaret Mills")) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logTrace("test_concatHavingClause:  Did not get expected results. Expected: Margaret Mills, got: " + result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_concatHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lowerHavingClause() throws Exception {
        boolean pass = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.count((Expression)customer.get("country").get("code"))).groupBy(new Expression[]{customer.get("country").get("code")}).having((Expression)cbuilder.equal(cbuilder.lower((Expression)customer.get("country").get("code")), (Object)"gbr"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    this.logTrace("Expected results received");
                    pass = true;
                    continue;
                }
                this.logErr("Did not get expected results. Expected 2 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_lowerHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_upperHavingClause() throws Exception {
        boolean pass = false;
        Long expectedCount = 2L;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)cbuilder.count((Expression)customer.get("country").get("country"))).groupBy(new Expression[]{customer.get("country").get("country")}).having((Expression)cbuilder.equal(cbuilder.upper((Expression)customer.get("country").get("country")), (Object)"ENGLAND"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            for (Long l : result) {
                if (l.equals(expectedCount)) {
                    pass = true;
                    this.logTrace("Expected results received");
                    pass = true;
                    continue;
                }
                this.logErr("Did not get expected results. Expected 2 references, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_upperHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_lengthHavingClause() throws Exception {
        boolean pass = false;
        Object[] expectedCities = new String[]{"Burlington", "Chelmsford", "Roslindale"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            Join a = customer.join("home");
            cquery.groupBy(new Expression[]{a.get("city")}).having((Expression)cbuilder.equal(cbuilder.length((Expression)a.get("city")), (Object)10)).select((Selection)a.get("city"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCities, output);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 2 Cities, got: " + result.size());
                for (Object s : expectedCities) {
                    this.logErr("Expected:" + (String)s);
                }
                for (Object s : output) {
                    this.logErr("Actual:" + (String)s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_lengthHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_locateHavingClause() throws Exception {
        boolean pass = false;
        Object[] expectedCusts = new String[]{"Alan E. Frechette", "Arthur D. Frechette"};
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.groupBy(new Expression[]{customer.get("name")}).having((Expression)cbuilder.gt(cbuilder.locate((Expression)customer.get("name"), "Frechette"), (Number)0)).select((Selection)customer.get("name"));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            Object[] output = result.toArray(new String[result.size()]);
            Arrays.sort(output);
            pass = Arrays.equals(expectedCusts, output);
            if (!pass) {
                this.logErr("Did not get expected results.  Expected 2 Customers, got: " + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception(" test_locateHavingClause failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void test_subquery_in() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            boolean isCorr = customer.isCorrelated();
            if (!isCorr) {
                this.logTrace("Root.isCorrelated() return false");
            } else {
                this.logErr("Expected Root.isCorrelated() to return false, actual:" + isCorr);
            }
            Root sqc = sq.correlate(customer);
            isCorr = sqc.isCorrelated();
            if (isCorr) {
                this.logTrace("Root.isCorrelated() return true");
            } else {
                this.logErr("Expected Root.isCorrelated() to return true, actual:" + isCorr);
            }
            From f = sqc.getCorrelationParent();
            String name = f.getJavaType().getSimpleName();
            if (name.equals("Customer")) {
                this.logTrace("Received expected parent:" + name);
            } else {
                this.logErr("Expected getCorrelationParent() to return Customer, actual:" + name);
            }
            Join w = sqc.join("work");
            sq.select((Expression)w.get("state"));
            sq.where((Expression)cbuilder.equal((Expression)w.get("state"), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get("home").get("state").in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("test_subquery_in failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fromIsCorrelatedTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            Root customer;
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root rCustomer = customer = cquery.from(Customer.class);
            boolean isCorr = rCustomer.isCorrelated();
            if (!isCorr) {
                this.logTrace("isCorrelated() return false");
            } else {
                this.logErr("Expected isCorrelated() to return false, actual:" + isCorr);
            }
            cquery.select((Selection)customer);
            Subquery sq = cquery.subquery(String.class);
            Root sqc = sq.correlate(customer);
            isCorr = sqc.isCorrelated();
            if (isCorr) {
                this.logTrace("isCorrelated() return true");
            } else {
                this.logErr("Expected isCorrelated() to return true, actual:" + isCorr);
            }
            Join w = sqc.join("work");
            sq.select((Expression)w.get("state"));
            sq.where((Expression)cbuilder.equal((Expression)w.get("state"), (Expression)cbuilder.parameter(String.class, "state")));
            cquery.where((Expression)customer.get("home").get("state").in(new Expression[]{sq}));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            tquery.setParameter("state", (Object)"MA");
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"1", "2", "3", "4", "7", "8", "9", "11", "13", "15", "18"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("test_subquery_in:  Did not get expected results.  Expected 11 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("fromIsCorrelatedTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fetchStringTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch("spouse");
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results. Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("fetchStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void fetchStringJoinTypeTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            customer.fetch("spouse", JoinType.INNER);
            Set s = customer.getFetches();
            if (s.size() == 1) {
                this.logTrace("Received expected size:" + s.size());
                for (Fetch f : s) {
                    String name = f.getAttribute().getName();
                    if (name.equals("spouse")) {
                        this.logTrace("Received expected attribute:" + name);
                    } else {
                        this.logErr("Expected attribute: spouse, actual:" + name);
                    }
                    JoinType type = f.getJoinType();
                    if (type.equals((Object)JoinType.INNER)) {
                        this.logTrace("Received expected JoinType:" + String.valueOf(type));
                        continue;
                    }
                    this.logErr("Expected JoinType:" + String.valueOf(JoinType.INNER) + ", actual:" + String.valueOf(type));
                }
            } else {
                this.logErr("Expected size: 1, actual:" + s.size());
            }
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            String[] expectedPKs = new String[]{"7", "10", "11", "12", "13"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                this.logErr("Did not get expected results. Expected 5 references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("fetchStringJoinTypeTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    public void isNullOneToOneTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            this.logTrace("find All Customers who have a null work zip code");
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)customer.get("home").isNull());
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            String[] expectedPKs = new String[]{"19", "20"};
            if (!this.checkEntityPK(clist, expectedPKs)) {
                this.logErr("Did not get expected results.  Expected 1 reference, got: " + clist.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught unexpected exception", e);
        }
        if (!pass) {
            throw new Exception("isNullOneToOneTest failed");
        }
    }
}

