/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.glassfish.admin.rest.provider.ProviderUtil;
import org.glassfish.admin.rest.utils.ConfigModelComparator;
import org.glassfish.admin.rest.utils.DomConfigurator;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.restconnector.RestConfig;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;

@Provider
public abstract class BaseProvider<T>
implements MessageBodyWriter<T> {
    public static final String HEADER_DEBUG = "__debug";
    public static final String JSONP_CALLBACK = "jsoncallback";
    @Inject
    protected ServiceLocator locator;
    @Inject
    protected UriInfo uriInfo;
    @Inject
    protected HttpHeaders requestHeaders;
    protected Class<T> desiredType;
    protected MediaType[] supportedMediaTypes;

    public BaseProvider(Class<T> desiredType, MediaType ... mediaType) {
        this.desiredType = desiredType;
        if (mediaType == null) {
            mediaType = new MediaType[]{};
        }
        this.supportedMediaTypes = mediaType;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] antns, MediaType mt) {
        if (this.isGivenTypeWritable(type, genericType)) {
            for (MediaType supportedMediaType : this.supportedMediaTypes) {
                if (!mt.isCompatible(supportedMediaType)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    public long getSize(T t, Class<?> type, Type type1, Annotation[] antns, MediaType mt) {
        return -1L;
    }

    public void writeTo(T proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.getContent(proxy).getBytes(StandardCharsets.UTF_8));
    }

    public abstract String getContent(T var1);

    protected int getFormattingIndentLevel() {
        RestConfig rg = ResourceUtil.getRestConfig(this.locator);
        if (rg == null) {
            return -1;
        }
        return Integer.parseInt(rg.getIndentLevel());
    }

    protected boolean canShowHiddenCommands() {
        RestConfig rg = ResourceUtil.getRestConfig(this.locator);
        return rg != null && "true".equalsIgnoreCase(rg.getShowHiddenCommands());
    }

    protected boolean canShowDeprecatedItems() {
        RestConfig rg = ResourceUtil.getRestConfig(this.locator);
        return rg != null && "true".equalsIgnoreCase(rg.getShowDeprecatedItems());
    }

    protected boolean isDebug() {
        RestConfig rg = ResourceUtil.getRestConfig(this.locator);
        if (rg != null && "true".equalsIgnoreCase(rg.getDebug())) {
            return true;
        }
        if (this.requestHeaders == null) {
            return true;
        }
        List header = this.requestHeaders.getRequestHeader(HEADER_DEBUG);
        return header != null && "true".equals(header.get(0));
    }

    protected String getCallBackJSONP() {
        if (this.uriInfo == null) {
            return null;
        }
        MultivaluedMap l = this.uriInfo.getQueryParameters();
        if (l == null) {
            return null;
        }
        return (String)l.getFirst((Object)JSONP_CALLBACK);
    }

    protected String getXmlCommandLinks(String[][] commandResourcesPaths, String indent) {
        StringBuilder result = new StringBuilder();
        for (String[] commandResourcePath : commandResourcesPaths) {
            result.append("\n").append(indent).append(ProviderUtil.getStartXmlElement("command")).append(ProviderUtil.getElementLink(this.uriInfo, commandResourcePath[0])).append(ProviderUtil.getEndXmlElement("command"));
        }
        return result.toString();
    }

    protected Map<String, String> getResourceLinks(Dom dom) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Set elementNames = dom.model.getElementNames();
        for (String elementName : elementNames) {
            if (elementName.equals("*")) {
                ConfigModel.Node node = (ConfigModel.Node)dom.model.getElement(elementName);
                ConfigModel childModel = node.getModel();
                List<ConfigModel> lcm = ResourceUtil.getRealChildConfigModels(childModel, dom.document);
                Collections.sort(lcm, new ConfigModelComparator());
                Collections.sort(lcm, new ConfigModelComparator());
                for (ConfigModel cmodel : lcm) {
                    links.put(cmodel.getTagName(), ProviderUtil.getElementLink(this.uriInfo, cmodel.getTagName()));
                }
                continue;
            }
            links.put(elementName, ProviderUtil.getElementLink(this.uriInfo, elementName));
        }
        return links;
    }

    protected Map<String, String> getResourceLinks(List<Dom> proxyList) {
        TreeMap<String, String> links = new TreeMap<String, String>();
        Collections.sort(proxyList, new DomConfigurator());
        for (Dom proxy : proxyList) {
            try {
                links.put(proxy.getKey(), ProviderUtil.getElementLink(this.uriInfo, proxy.getKey()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return links;
    }
}

