/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.DescriptorArchivist;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.deploy.shared.InputJarArchive;
import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.deployment.ApplicationInfoProvider;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXException;

@Service
public class DolProvider
implements ApplicationMetaDataProvider<Application>,
ApplicationInfoProvider {
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected DescriptorArchivist descriptorArchivist;
    @Inject
    protected ApplicationArchivist applicationArchivist;
    @Inject
    Domain domain;
    @Inject
    DasConfig dasConfig;
    @Inject
    Deployment deployment;
    @Inject
    ServerEnvironment env;
    @Inject
    Provider<ClassLoaderHierarchy> clhProvider;
    private static final String WRITEOUT_XML = System.getProperty("writeout.xml");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DolProvider.class);

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{Application.class}, null);
    }

    private Application processDOL(DeploymentContext dc) throws IOException {
        ReadableArchive sourceArchive = dc.getSource();
        sourceArchive.setExtraData(Types.class, (Object)((Types)dc.getTransientAppMetaData(Types.class.getName(), Types.class)));
        sourceArchive.setExtraData(Parser.class, (Object)((Parser)dc.getTransientAppMetaData(Parser.class.getName(), Parser.class)));
        ClassLoader cl = dc.getClassLoader();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        sourceArchive.addArchiveMetaData("appprops", (Object)dc.getAppProps());
        sourceArchive.addArchiveMetaData("commandparams", (Object)params);
        String name = params.name();
        String archiveType = dc.getArchiveHandler().getArchiveType();
        Archivist archivist = this.archivistFactory.getArchivist(archiveType, cl);
        if (archivist == null) {
            return Application.createApplication();
        }
        archivist.setAnnotationProcessingRequested(true);
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        archivist.setXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            archivist.setXMLValidation(false);
        }
        archivist.setRuntimeXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            archivist.setRuntimeXMLValidation(false);
        }
        Collection sniffers = (Collection)dc.getTransientAppMetaData("sniffers", Collection.class);
        archivist.setExtensionArchivists(this.archivistFactory.getExtensionsArchivists(sniffers, archivist.getModuleType()));
        ApplicationHolder holder = (ApplicationHolder)dc.getModuleMetaData(ApplicationHolder.class);
        File deploymentPlan = params.deploymentplan;
        this.handleDeploymentPlan(deploymentPlan, archivist, sourceArchive, holder);
        long start = System.currentTimeMillis();
        Application application = null;
        if (holder != null) {
            application = holder.app;
            application.setAppName(name);
            application.setClassLoader(cl);
            if (application.isVirtual()) {
                ModuleDescriptor md = application.getStandaloneBundleDescriptor().getModuleDescriptor();
                md.setModuleName(name);
            }
            try {
                this.applicationFactory.openWith(application, sourceArchive, archivist);
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
        }
        try {
            application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
            application.setAppName(name);
            ModuleDescriptor md = application.getStandaloneBundleDescriptor().getModuleDescriptor();
            md.setModuleName(name);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        application.setRegistrationName(name);
        sourceArchive.removeExtraData(Types.class);
        sourceArchive.removeExtraData(Parser.class);
        Logger.getAnonymousLogger().log(Level.FINE, "DOL Loading time: {0} ms", System.currentTimeMillis() - start);
        return application;
    }

    public Application load(DeploymentContext dc) throws IOException {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        Application application = this.processDOL(dc);
        if (Boolean.parseBoolean(WRITEOUT_XML)) {
            this.saveAppDescriptor(application, dc);
        }
        if (application.isVirtual()) {
            dc.addModuleMetaData((Object)application.getStandaloneBundleDescriptor());
            for (RootDeploymentDescriptor extension : application.getStandaloneBundleDescriptor().getExtensionsDescriptors()) {
                dc.addModuleMetaData((Object)extension);
            }
        }
        this.addModuleConfig(dc, application);
        this.validateKeepStateOption(dc, params, application);
        return application;
    }

    public String getNameFor(ReadableArchive archive, DeploymentContext context) {
        if (context == null) {
            return null;
        }
        DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        Application application = null;
        try {
            if (params.altdd != null || archive.exists("META-INF/application.xml") || archive.exists("WEB-INF/web.xml") || archive.exists("META-INF/ejb-jar.xml") || archive.exists("META-INF/application-client.xml") || archive.exists("META-INF/ra.xml")) {
                String archiveType = context.getArchiveHandler().getArchiveType();
                application = this.applicationFactory.createApplicationFromStandardDD(archive, archiveType);
                DeploymentTracing tracing = null;
                tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
                if (tracing != null) {
                    tracing.addMark(DeploymentTracing.Mark.DOL_LOADED);
                }
                ApplicationHolder holder = new ApplicationHolder(application);
                context.addModuleMetaData((Object)holder);
                return application.getAppName();
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error occurred", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application processDeploymentMetaData(ReadableArchive archive) throws Exception {
        ArchiveHandler archiveHandler = this.deployment.getArchiveHandler(archive);
        if (archiveHandler == null) {
            throw new IllegalArgumentException(localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{archive.getURI()}));
        }
        DeployCommandParameters parameters = new DeployCommandParameters(new File(archive.getURI()));
        HTMLActionReporter report = new HTMLActionReporter();
        DeploymentContextImpl context = new DeploymentContextImpl((ActionReport)report, archive, (OpsParams)parameters, this.env);
        try {
            context.setArchiveHandler(archiveHandler);
            parameters.name = archiveHandler.getDefaultApplicationName(archive, (DeploymentContext)context);
            Application application = this.processDeployment(archive, archiveHandler, (ExtendedDeploymentContext)context);
            return application;
        }
        finally {
            context.postDeployClean(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Application processDeployment(ReadableArchive archive, ArchiveHandler archiveHandler, ExtendedDeploymentContext context) throws IOException, URISyntaxException, MalformedURLException {
        File tmpDirectory = this.prepareTmpDir(archive);
        try {
            if (tmpDirectory != null) {
                WritableArchive expandedArchive = this.archiveFactory.createArchive(tmpDirectory);
                archiveHandler.expand(archive, expandedArchive, (DeploymentContext)context);
                context.setSource((ReadableArchive)expandedArchive);
            }
            context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
            context.createDeploymentClassLoader((ClassLoaderHierarchy)this.clhProvider.get(), archiveHandler);
            Application application = this.processDeployment(archiveHandler, context);
            return application;
        }
        finally {
            if (context.getSource() != null) {
                context.getSource().close();
            }
            if (tmpDirectory != null) {
                try {
                    FileUtils.whack((File)tmpDirectory);
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "Could not delete the temporary directory " + String.valueOf(tmpDirectory), e);
                }
            }
        }
    }

    private File prepareTmpDir(ReadableArchive archive) throws IOException {
        if (!(archive instanceof InputJarArchive)) {
            return null;
        }
        String archiveName = Util.getURIName((URI)archive.getURI());
        File tmpFile = File.createTempFile(archiveName, "");
        String path = tmpFile.getAbsolutePath();
        if (!tmpFile.delete()) {
            Logger.getAnonymousLogger().log(Level.WARNING, "cannot.delete.temp.file", path);
        }
        File tmpDir = new File(path);
        tmpDir.deleteOnExit();
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Unable to create directory " + tmpDir.getAbsolutePath());
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Application processDeployment(ArchiveHandler archiveHandler, ExtendedDeploymentContext context) throws IOException {
        ClassLoader cl = context.getClassLoader();
        try {
            this.deployment.getDeployableTypes((DeploymentContext)context);
            this.deployment.getSniffers(archiveHandler, null, (DeploymentContext)context);
            Application application = this.processDOL((DeploymentContext)context);
            return application;
        }
        finally {
            if (cl instanceof PreDestroy) {
                try {
                    ((PreDestroy)PreDestroy.class.cast(cl)).preDestroy();
                }
                catch (Exception e) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "ClassLoader preDestroy failed for " + String.valueOf(cl), e);
                }
            }
        }
    }

    protected void handleDeploymentPlan(File deploymentPlan, Archivist archivist, ReadableArchive sourceArchive, ApplicationHolder holder) throws IOException {
        if (deploymentPlan == null) {
            return;
        }
        try (DeploymentPlanArchive dpa = new DeploymentPlanArchive();){
            dpa.setParentArchive(sourceArchive);
            dpa.open(deploymentPlan.toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            if (archivist instanceof ApplicationArchivist) {
                ((ApplicationArchivist)archivist).copyInto(holder.app, (ReadableArchive)dpa, targetArchive, false);
            } else {
                archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
            }
        }
    }

    protected void saveAppDescriptor(Application application, DeploymentContext context) throws IOException {
        if (application != null) {
            ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
            boolean isMkdirs = context.getScratchDir("xml").mkdirs();
            if (isMkdirs) {
                WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
                this.descriptorArchivist.write(application, archive, archive2);
                this.applicationArchivist.copyExtraElements(archive, archive2);
            } else {
                context.getLogger().log(Level.WARNING, "Error in creating directory " + context.getScratchDir("xml").getAbsolutePath());
            }
        }
    }

    private void addModuleConfig(DeploymentContext dc, Application application) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (!params.origin.isDeploy()) {
            return;
        }
        try {
            com.sun.enterprise.config.serverbeans.Application app_w = (com.sun.enterprise.config.serverbeans.Application)dc.getTransientAppMetaData("application", com.sun.enterprise.config.serverbeans.Application.class);
            if (app_w != null) {
                if (application.isVirtual()) {
                    Module modConfig = (Module)app_w.createChild(Module.class);
                    app_w.getModule().add(modConfig);
                    modConfig.setName(application.getRegistrationName());
                } else {
                    for (ModuleDescriptor moduleDesc : application.getModules()) {
                        Module modConfig = (Module)app_w.createChild(Module.class);
                        app_w.getModule().add(modConfig);
                        modConfig.setName(moduleDesc.getArchiveUri());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "failed to add the module config", e);
        }
    }

    private void validateKeepStateOption(DeploymentContext context, DeployCommandParameters params, Application app) {
        if ((params.keepstate != null && params.keepstate.booleanValue() || app.getKeepState()) && !this.isDASTarget(context, params)) {
            params.keepstate = false;
            String warningMsg = localStrings.getLocalString("not.support.keepstate.in.cluster", "Ignoring the keepstate setting: the keepstate option is only supported in developer profile and not cluster profile.");
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            subReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            subReport.setMessage(warningMsg);
            context.getLogger().log(Level.WARNING, warningMsg);
        }
    }

    private boolean isDASTarget(DeploymentContext context, DeployCommandParameters params) {
        if (DeploymentUtils.isDASTarget((String)params.target)) {
            return true;
        }
        if (DeploymentUtils.isDomainTarget((String)params.target)) {
            List targets = (List)context.getTransientAppMetaData("previousTargets", List.class);
            if (targets == null) {
                targets = this.domain.getAllReferencedTargetsForApplication(params.name);
            }
            if (targets.size() == 1 && DeploymentUtils.isDASTarget((String)((String)targets.get(0)))) {
                return true;
            }
        }
        return false;
    }
}

