/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.Encoder;
import org.glassfish.grizzly.memory.CompositeBuffer;
import org.glassfish.grizzly.memory.MemoryManager;

public class HeadersEncoder {
    private static final String DEFAULT_BUFFER_SIZE_PROP_NAME = "org.glassfish.grizzly.http2.HeadersEncoder.DEFAULT_BUFFER_SIZE";
    private static final String DEFAULT_BUFFER_SIZE_STRING = "8192";
    private static final int DEFAULT_BUFFER_SIZE = Integer.parseInt(System.getProperty("org.glassfish.grizzly.http2.HeadersEncoder.DEFAULT_BUFFER_SIZE", "8192"));
    private final Encoder hpackEncoder;
    private final MemoryManager memoryManager;
    private CompositeBuffer buffer;

    public HeadersEncoder(MemoryManager memoryManager, int maxHeaderTableSize) {
        this.memoryManager = memoryManager;
        this.hpackEncoder = new Encoder(maxHeaderTableSize);
    }

    public void encodeHeader(String name, String value, Map<String, String> capture) {
        if (capture != null) {
            capture.put(name, value);
        }
        this.init();
        this.hpackEncoder.header(name, value);
        while (!this.hpackEncoder.encode(this.buffer)) {
            this.buffer.append((Buffer)this.memoryManager.allocate(DEFAULT_BUFFER_SIZE));
        }
    }

    public Buffer flushHeaders() {
        CompositeBuffer bufferLocal = this.buffer;
        bufferLocal.trim();
        this.buffer = null;
        return bufferLocal;
    }

    private void init() {
        if (this.buffer == null) {
            this.buffer = CompositeBuffer.newBuffer(this.memoryManager);
            this.buffer.allowInternalBuffersDispose(true);
            this.buffer.allowBufferDispose(true);
            this.buffer.append((Buffer)this.memoryManager.allocate(DEFAULT_BUFFER_SIZE));
        }
    }
}

