/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.net.URL;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.i18n.ExceptionMessageGenerator;

public class StaticWeaveException
extends EclipseLinkException {
    private String resourceName = null;
    public static final int EXCEPTION_OPENNING_ARCHIVE = 40001;
    public static final int EXCEPTION_NO_SOURCE_SPECIFIED = 40002;
    public static final int EXCEPTION_NO_TARGET_SPECIFIED = 40003;
    public static final int EXCEPTION_NO_SUPPORT_WEAVING_INPLACE_FOR_JAR = 40004;
    public static final int EXCEPTION_OPEN_LOGGING_FILE = 40005;
    public static final int EXCEPTION_FOR_ILLEGALE_LOGGING_LEVEL = 40006;
    public static final int EXCEPTION_WEAVING = 40007;

    public StaticWeaveException() {
    }

    protected StaticWeaveException(String message) {
        super(message);
    }

    protected StaticWeaveException(String message, Throwable internalException) {
        super(message);
        this.setInternalException(internalException);
    }

    public static StaticWeaveException exceptionOpeningArchive(URL archive, Exception cause) {
        Object[] args = new Object[]{archive};
        StaticWeaveException openArchiveException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40001, (Object[])args), cause);
        openArchiveException.setResourceName(archive.toString());
        openArchiveException.setErrorCode(40001);
        return openArchiveException;
    }

    public static StaticWeaveException weaveInplaceForJar(String filePath) {
        Object[] args = new Object[]{filePath};
        StaticWeaveException loadingException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40004, (Object[])args));
        loadingException.setResourceName(filePath);
        loadingException.setErrorCode(40004);
        return loadingException;
    }

    public static StaticWeaveException missingSource() {
        Object[] args = new Object[]{null};
        StaticWeaveException missingSourceException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40002, (Object[])args));
        missingSourceException.setResourceName(null);
        missingSourceException.setErrorCode(40002);
        return missingSourceException;
    }

    public static StaticWeaveException missingTarget() {
        Object[] args = new Object[]{null};
        StaticWeaveException missingTargetException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40003, (Object[])args));
        missingTargetException.setResourceName(null);
        missingTargetException.setErrorCode(40003);
        return missingTargetException;
    }

    public static StaticWeaveException openLoggingFileException(String LoggingFile, Exception cause) {
        Object[] args = new Object[]{LoggingFile};
        StaticWeaveException loadingException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40005, (Object[])args), cause);
        loadingException.setResourceName(LoggingFile);
        loadingException.setErrorCode(40005);
        return loadingException;
    }

    public static StaticWeaveException illegalLoggingLevel(String loggingLevel) {
        Object[] args = new Object[]{loggingLevel};
        StaticWeaveException loadingException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40006, (Object[])args));
        loadingException.setResourceName(loggingLevel);
        loadingException.setErrorCode(40006);
        return loadingException;
    }

    public static StaticWeaveException exceptionPerformWeaving(Exception cause, Object sourceJar) {
        Object[] args = new Object[]{sourceJar};
        StaticWeaveException loadingException = new StaticWeaveException(ExceptionMessageGenerator.buildMessage(StaticWeaveException.class, (int)40007, (Object[])args), cause);
        loadingException.setResourceName(null);
        loadingException.setErrorCode(40007);
        return loadingException;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
}

