/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.UnionField;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;

public class XMLUnionField
extends XMLField
implements UnionField<XMLConversionManager, NamespaceResolver> {
    private ArrayList schemaTypes = new ArrayList();

    public XMLUnionField() {
    }

    public XMLUnionField(String xPath) {
        super(xPath);
    }

    public ArrayList getSchemaTypes() {
        return this.schemaTypes;
    }

    public void setSchemaTypes(ArrayList value) {
        this.schemaTypes = value;
    }

    @Override
    public void addSchemaType(QName value) {
        if (value != null) {
            if (this.schemaTypes == null) {
                this.schemaTypes = new ArrayList();
            }
            if (!this.contains(this.schemaTypes, value)) {
                this.schemaTypes.add(value);
            }
        }
    }

    @Override
    public QName getSchemaType() {
        if (this.schemaTypes != null) {
            return (QName)this.getSchemaTypes().get(0);
        }
        return null;
    }

    @Override
    public void setSchemaType(QName value) {
        this.addSchemaType(value);
    }

    private boolean contains(ArrayList types, QName value) {
        for (QName type : types) {
            if (!type.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUnionField() {
        return true;
    }

    @Override
    public QName getSchemaTypeForValue(Object value, CoreAbstractSession session) {
        if (this.leafElementType != null) {
            return this.leafElementType;
        }
        if (this.isTypedTextField()) {
            ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
            return this.getXMLType(value.getClass(), conversionManager);
        }
        return this.getSingleValueToWriteForUnion(value, session);
    }

    protected QName getSingleValueToWriteForUnion(Object value, CoreAbstractSession session) {
        ArrayList schemaTypes = this.getSchemaTypes();
        QName schemaType = null;
        int schemaTypesSize = schemaTypes.size();
        for (int i = 0; i < schemaTypesSize; ++i) {
            QName nextQName = (QName)this.getSchemaTypes().get(i);
            try {
                if (nextQName == null) continue;
                ConversionManager conversionManager = (ConversionManager)session.getDatasourcePlatform().getConversionManager();
                Class<?> javaClass = this.getJavaClass(nextQName, conversionManager);
                conversionManager.convertObject(value, javaClass, nextQName);
                schemaType = nextQName;
                break;
            }
            catch (ConversionException ce) {
                if (i != schemaTypes.size() - 1) continue;
                schemaType = nextQName;
            }
        }
        return schemaType;
    }

    @Override
    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager, AbstractUnmarshalRecord record) {
        Object convertedValue = value;
        for (int i = 0; i < this.schemaTypes.size(); ++i) {
            QName nextQName = (QName)this.schemaTypes.get(i);
            try {
                if (nextQName == null) continue;
                if (XMLConstants.QNAME_QNAME.equals(nextQName)) {
                    xmlConversionManager.buildQNameFromString((String)value, record);
                    break;
                }
                Class<?> javaClass = this.getJavaClass(nextQName, xmlConversionManager);
                convertedValue = xmlConversionManager.convertObject(value, javaClass, nextQName);
                break;
            }
            catch (ConversionException ce) {
                if (i != this.schemaTypes.size() - 1) continue;
                throw ce;
            }
        }
        return convertedValue;
    }

    @Override
    public Class<?> getJavaClass(QName qname) {
        return this.getJavaClass(qname, XMLConversionManager.getDefaultXMLManager());
    }

    @Override
    public Class<?> getJavaClass(QName qname, ConversionManager conversionManager) {
        Class theClass;
        if (this.userXMLTypes != null && (theClass = (Class)this.userXMLTypes.get(qname)) != null) {
            return theClass;
        }
        Class javaClass = conversionManager.javaType(qname);
        return XMLConversionManager.getObjectClass(javaClass);
    }

    @Override
    public boolean isSchemaType(QName schemaType) {
        if (this.getSchemaTypes() == null || this.getSchemaTypes().isEmpty()) {
            return false;
        }
        return this.contains(this.getSchemaTypes(), schemaType);
    }
}

