/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Comparator;
import org.eclipse.persistence.internal.identitymaps.CacheId;

class CacheIdComparator
implements Comparator<CacheId> {
    CacheIdComparator() {
    }

    @Override
    public int compare(CacheId id1, CacheId id2) {
        if (id1 == id2) {
            return 0;
        }
        return this.compareObjectArrays(id1.primaryKey, id2.primaryKey);
    }

    private int compareObjectArrays(Object[] array1, Object[] array2) {
        if (array1.length == array2.length) {
            for (int index = 0; index < array1.length; ++index) {
                Object value1 = array1[index];
                Object value2 = array2[index];
                if (value1 == null) {
                    if (value2 == null) continue;
                    return -1;
                }
                if (value2 == null) {
                    return 1;
                }
                Class<?> value1Class = value1.getClass();
                if (value1Class.isArray()) {
                    int result;
                    Class<?> value2Class = value2.getClass();
                    if (!(value1Class == CacheId.APBYTE && value2Class == CacheId.APBYTE ? (result = this.compareByteArrays((byte[])value1, (byte[])value2)) != 0 : (value1Class == CacheId.APCHAR && value2Class == CacheId.APCHAR ? (result = this.compareCharArrays((char[])value1, (char[])value2)) != 0 : (result = this.compareObjectArrays((Object[])value1, (Object[])value2)) != 0))) continue;
                    return result;
                }
                if (value1.getClass().isInstance(value2) && value1 instanceof Comparable) {
                    int result = this.compareComparable((Comparable)value1, (Comparable)value2);
                    if (result == 0) continue;
                    return result;
                }
                if (value2.getClass().isInstance(value1) && value1 instanceof Comparable) {
                    int result = this.compareComparable((Comparable)value2, (Comparable)value1);
                    if (result == 0) continue;
                    return result;
                }
                int result = value1.hashCode() - value2.hashCode();
                if (result == 0) continue;
                return result > 0 ? 1 : -1;
            }
            return 0;
        }
        return array1.length > array2.length ? 1 : -1;
    }

    private int compareCharArrays(char[] array1, char[] array2) {
        if (array1.length == array2.length) {
            for (int index = 0; index < array1.length; ++index) {
                if (array1[index] == array2[index]) continue;
                return array1[index] > array2[index] ? 1 : -1;
            }
            return 0;
        }
        return array1.length > array2.length ? 1 : -1;
    }

    private int compareByteArrays(byte[] array1, byte[] array2) {
        if (array1.length == array2.length) {
            for (int index = 0; index < array1.length; ++index) {
                if (array1[index] == array2[index]) continue;
                return array1[index] > array2[index] ? 1 : -1;
            }
            return 0;
        }
        return array1.length > array2.length ? 1 : -1;
    }

    private int compareComparable(Comparable value1, Comparable value2) {
        return value1.compareTo(value2);
    }
}

