/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.config.ConfigBeanProxy;

public class DeploymentCommandUtils {
    public static final String APPLICATION_RESOURCE_NAME = "domain/applications/application";
    static final String LIBRARY_SECURITY_RESOURCE_PREFIX = "domain/libraries/";
    static final String CLUSTERS_RESOURCE_NAME = "domain/clusters/cluster";
    static final String SERVERS_RESOURCE_NAME = "domain/servers/server";
    private static final String COPY_IN_PLACE_ARCHIVE_PROP_NAME = "copy.inplace.archive";

    public static ActionReport.ExitCode replicateEnableDisableToContainingCluster(String commandName, Domain domain, String target, String appName, ServiceLocator habitat, AdminCommandContext context, AdminCommand command) throws IllegalArgumentException, IllegalAccessException {
        Cluster containingCluster = domain.getClusterForInstance(target);
        if (containingCluster != null) {
            ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{command});
            ParameterMap pMap = extractor.extract(Collections.emptyList());
            pMap.set((Object)"DEFAULT", (Object)appName);
            return ClusterOperationUtil.replicateCommand((String)commandName, (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Ignore, (List)containingCluster.getInstances(), (AdminCommandContext)context, (ParameterMap)pMap, (ServiceLocator)habitat);
        }
        return ActionReport.ExitCode.SUCCESS;
    }

    public static String getLocalHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }

    public static String getTarget(ParameterMap parameters, OpsParams.Origin origin, Deployment deployment) {
        String appName = (String)parameters.getOne((Object)"DEFAULT");
        Boolean isClassicStyle = Boolean.valueOf((String)parameters.getOne((Object)"_classicstyle"));
        String targetName = deployment.getDefaultTarget(appName, origin, isClassicStyle);
        parameters.set((Object)"target", (Object)targetName);
        return targetName;
    }

    public static File renameUploadedFileOrCopyInPlaceFile(File targetDirectory, File fileParam, File appsDir) throws IOException {
        if (fileParam == null) {
            return null;
        }
        if (!fileParam.isDirectory() && !appsDir.toURI().relativize(fileParam.toURI()).isAbsolute()) {
            File result = new File(targetDirectory, fileParam.getName());
            long lastMod = fileParam.lastModified();
            if (!FileUtils.renameFile((File)fileParam, (File)result)) {
                throw new IOException("Failed to move file " + fileParam.getAbsolutePath() + " to " + result.getAbsolutePath());
            }
            if (!result.setLastModified(lastMod)) {
                throw new IOException("Failed to set the last modified timestamp of file " + result.getAbsolutePath());
            }
            return result;
        }
        boolean copyInPlaceArchive = Boolean.valueOf(System.getProperty(COPY_IN_PLACE_ARCHIVE_PROP_NAME, "true"));
        if (fileParam.isDirectory() || !copyInPlaceArchive) {
            return fileParam;
        }
        File result = new File(targetDirectory, fileParam.getName());
        FileUtils.copy((File)fileParam, (File)result);
        if (!result.setLastModified(fileParam.lastModified())) {
            throw new IOException("Failed to set the last modified timestamp of file " + result.getAbsolutePath());
        }
        return result;
    }

    private static StringBuilder getTargetResourceName(Domain d, String target) {
        StringBuilder sb = new StringBuilder();
        Server p = d.getServerNamed(target);
        if (p == null) {
            p = d.getClusterNamed(target);
        }
        if (p == null) {
            sb.append("domain/???/").append(target);
        } else {
            sb.append(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)p));
        }
        return sb;
    }

    public static Collection<? extends AccessRequired.AccessCheck> getAccessChecksForExistingApp(Domain domain, Applications applications, String target, Collection<String> matchedVersions, String appAction, String appRefAction) {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        List targets = domain.getTargets(target);
        for (String mv : matchedVersions) {
            Application app = applications.getApplication(mv);
            if (app == null) continue;
            accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getResourceNameForExistingApp(domain, mv), appAction));
            for (String t : targets) {
                ApplicationRef ar = domain.getApplicationRefInTarget(mv, t);
                if (ar == null) continue;
                accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForExistingAppRef(domain, t, mv), appRefAction));
            }
        }
        return accessChecks;
    }

    public static Collection<? extends AccessRequired.AccessCheck> getAccessChecksForNewApp(Domain domain, Applications applications, String target, String action) {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getResourceNameForApps(domain), action));
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(domain, target), action));
        return accessChecks;
    }

    public static String getTargetResourceNameForNewApp(Domain d, String target) {
        StringBuilder sb = DeploymentCommandUtils.getTargetResourceName(d, target);
        return sb.toString();
    }

    public static String getTargetResourceNameForExistingApp(Domain d, String target, String appName) {
        ApplicationRef appRef = d.getApplicationRefInTarget(appName, target);
        if (appRef != null) {
            return AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)appRef);
        }
        return null;
    }

    public static String getTargetResourceNameForNewAppRef(Domain d, String target) {
        return DeploymentCommandUtils.getTargetResourceNameForNewApp(d, target) + "/application-ref";
    }

    public static String getTargetResourceNameForNewAppRef(Domain d, String target, String appName) {
        return DeploymentCommandUtils.getTargetResourceNameForNewAppRef(d, target) + '/' + appName;
    }

    public static String getTargetResourceNameForExistingAppRef(Domain d, String target, String appName) {
        return AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)d.getApplicationRefInTarget(appName, target));
    }

    public static String getResourceNameForApps(Domain d) {
        return APPLICATION_RESOURCE_NAME;
    }

    public static String getResourceNameForNewApp(Domain d, String appName) {
        return APPLICATION_RESOURCE_NAME + '/' + appName;
    }

    public static String getResourceNameForExistingApp(Domain d, String appName) {
        Application app = d.getApplications().getApplication(appName);
        if (app != null) {
            return AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)app);
        }
        return null;
    }
}

