/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.common;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.common.MessageSecurityNode;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MessageSecurityBindingNode
extends DeploymentDescriptorNode<MessageSecurityBindingDescriptor> {
    private MessageSecurityBindingDescriptor descriptor;

    public MessageSecurityBindingNode() {
        this.registerElementHandler(new XMLElement("message-security"), MessageSecurityNode.class, "addMessageSecurityDescriptor");
    }

    @Override
    public MessageSecurityBindingDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MessageSecurityBindingDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected boolean setAttributeValue(XMLElement elementName, XMLElement attributeName, String value) {
        if (attributeName.getQName().equals("auth-layer")) {
            this.descriptor.setAttributeValue("AuthLayer", value);
            return true;
        }
        if (attributeName.getQName().equals("provider-id")) {
            this.descriptor.setAttributeValue("ProviderID", value);
            return true;
        }
        return false;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MessageSecurityBindingDescriptor messageSecurityBindingDesc) {
        Element messageSecurityBindingNode = (Element)super.writeDescriptor(parent, nodeName, messageSecurityBindingDesc);
        ArrayList<MessageSecurityDescriptor> messageSecDescs = messageSecurityBindingDesc.getMessageSecurityDescriptors();
        if (!messageSecDescs.isEmpty()) {
            MessageSecurityNode messageSecurityNode = new MessageSecurityNode();
            for (MessageSecurityDescriptor msDescriptor : messageSecDescs) {
                messageSecurityNode.writeDescriptor((Node)messageSecurityBindingNode, "message-security", msDescriptor);
            }
        }
        if (messageSecurityBindingDesc.getAttributeValue("AuthLayer") != null) {
            MessageSecurityBindingNode.setAttribute(messageSecurityBindingNode, "auth-layer", messageSecurityBindingDesc.getAttributeValue("AuthLayer"));
        }
        if (messageSecurityBindingDesc.getAttributeValue("ProviderID") != null) {
            MessageSecurityBindingNode.setAttribute(messageSecurityBindingNode, "provider-id", messageSecurityBindingDesc.getAttributeValue("ProviderID"));
        }
        return messageSecurityBindingNode;
    }
}

