/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jce;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KDF;
import com.jcraft.jsch.asn1.ASN1;
import com.jcraft.jsch.asn1.ASN1Exception;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class PBKDF2
implements KDF {
    private static final byte[] hmacWithSha1 = new byte[]{42, -122, 72, -122, -9, 13, 2, 7};
    private static final byte[] hmacWithSha224 = new byte[]{42, -122, 72, -122, -9, 13, 2, 8};
    private static final byte[] hmacWithSha256 = new byte[]{42, -122, 72, -122, -9, 13, 2, 9};
    private static final byte[] hmacWithSha384 = new byte[]{42, -122, 72, -122, -9, 13, 2, 10};
    private static final byte[] hmacWithSha512 = new byte[]{42, -122, 72, -122, -9, 13, 2, 11};
    private static final byte[] hmacWithSha512224 = new byte[]{42, -122, 72, -122, -9, 13, 2, 12};
    private static final byte[] hmacWithSha512256 = new byte[]{42, -122, 72, -122, -9, 13, 2, 13};
    private SecretKeyFactory skf;
    private byte[] salt;
    private int iterations;
    private String jceName;

    @Override
    public void initWithASN1(byte[] asn1) throws Exception {
        try {
            ASN1 prf = null;
            ASN1 content = new ASN1(asn1);
            if (!content.isSEQUENCE()) {
                throw new ASN1Exception();
            }
            ASN1[] contents = content.getContents();
            if (contents.length < 2 || contents.length > 4) {
                throw new ASN1Exception();
            }
            if (!contents[0].isOCTETSTRING()) {
                throw new ASN1Exception();
            }
            if (!contents[1].isINTEGER()) {
                throw new ASN1Exception();
            }
            if (contents.length == 4) {
                if (!contents[2].isINTEGER()) {
                    throw new ASN1Exception();
                }
                if (!contents[3].isSEQUENCE()) {
                    throw new ASN1Exception();
                }
                prf = contents[3];
            } else if (contents.length == 3) {
                if (contents[2].isSEQUENCE()) {
                    prf = contents[2];
                } else if (!contents[2].isINTEGER()) {
                    throw new ASN1Exception();
                }
            }
            byte[] prfid = null;
            this.salt = contents[0].getContent();
            this.iterations = ASN1.parseASN1IntegerAsInt(contents[1].getContent());
            if (prf != null) {
                contents = prf.getContents();
                if (contents.length != 2) {
                    throw new ASN1Exception();
                }
                if (!contents[0].isOBJECT()) {
                    throw new ASN1Exception();
                }
                if (!contents[1].isNULL()) {
                    throw new ASN1Exception();
                }
                prfid = contents[0].getContent();
            }
            this.jceName = PBKDF2.getJceName(prfid);
            this.skf = SecretKeyFactory.getInstance(this.jceName);
        }
        catch (Exception e) {
            if (e instanceof JSchException) {
                throw (JSchException)e;
            }
            if (e instanceof NoSuchAlgorithmException) {
                throw new JSchException("unsupported pbkdf2 algorithm: " + this.jceName, e);
            }
            if (e instanceof ASN1Exception || e instanceof ArithmeticException) {
                throw new JSchException("invalid ASN1", e);
            }
            throw new JSchException("pbkdf2 unavailable", e);
        }
    }

    @Override
    public byte[] getKey(byte[] _pass, int size) {
        char[] pass = new char[_pass.length];
        for (int i = 0; i < _pass.length; ++i) {
            pass[i] = (char)(_pass[i] & 0xFF);
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(pass, this.salt, this.iterations, size * 8);
            byte[] key = this.skf.generateSecret(spec).getEncoded();
            return key;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            return null;
        }
    }

    static String getJceName(byte[] id) throws JSchException {
        String name = null;
        if (id == null || Arrays.equals(id, hmacWithSha1)) {
            name = "PBKDF2WithHmacSHA1";
        } else if (Arrays.equals(id, hmacWithSha224)) {
            name = "PBKDF2WithHmacSHA224";
        } else if (Arrays.equals(id, hmacWithSha256)) {
            name = "PBKDF2WithHmacSHA256";
        } else if (Arrays.equals(id, hmacWithSha384)) {
            name = "PBKDF2WithHmacSHA384";
        } else if (Arrays.equals(id, hmacWithSha512)) {
            name = "PBKDF2WithHmacSHA512";
        } else if (Arrays.equals(id, hmacWithSha512224)) {
            name = "PBKDF2WithHmacSHA512/224";
        } else if (Arrays.equals(id, hmacWithSha512256)) {
            name = "PBKDF2WithHmacSHA512/256";
        }
        if (name == null) {
            throw new JSchException("unsupported pbkdf2 function oid: " + PBKDF2.toHex(id));
        }
        return name;
    }

    static String toHex(byte[] str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            String foo = Integer.toHexString(str[i] & 0xFF);
            sb.append("0x" + (foo.length() == 1 ? "0" : "") + foo);
            if (i + 1 >= str.length) continue;
            sb.append(":");
        }
        return sb.toString();
    }
}

