/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jnosql.jakartapersistence;

import jakarta.data.repository.DataRepository;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jnosql.jakartapersistence.mapping.metadata.JakartaPersistenceClassScanner;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.main.jnosql.hk2types.GeneralInterfaceModel;
import org.glassfish.main.jnosql.hk2types.Hk2TypesUtil;
import org.glassfish.main.jnosql.jakartapersistence.BaseGlassFishClassScanner;
import org.glassfish.persistence.jpa.JPADeployer;

public class GlassFishJakartaPersistenceClassScanner
extends BaseGlassFishClassScanner
implements JakartaPersistenceClassScanner {
    public static final String JPA_DATA_ENABLED_META_DATA_KEY = "JPADataEnabled";
    private static final System.Logger LOG = System.getLogger(GlassFishJakartaPersistenceClassScanner.class.getName());

    @Override
    public boolean isEnabled() {
        DeploymentContext deploymentContext = Hk2TypesUtil.getDeploymentContext();
        if (deploymentContext != null) {
            Boolean enabled = (Boolean)deploymentContext.getTransientAppMetaData(JPA_DATA_ENABLED_META_DATA_KEY, Boolean.class);
            if (enabled == null) {
                ApplicationInfo appInfo = (ApplicationInfo)deploymentContext.getModuleMetaData(ApplicationInfo.class);
                JPADeployer jpaDeployer = this.getJPADeployer();
                enabled = !jpaDeployer.getEntityManagerFactories(appInfo).isEmpty() && super.isEnabled();
                deploymentContext.addTransientAppMetaData(JPA_DATA_ENABLED_META_DATA_KEY, (Object)enabled);
            }
            return enabled;
        }
        return true;
    }

    private JPADeployer getJPADeployer() {
        ServiceLocator locator = Globals.getDefaultHabitat();
        return locator != null ? (JPADeployer)locator.getService(JPADeployer.class, new Annotation[0]) : null;
    }

    public Set<Class<?>> entities() {
        Set<Class<?>> result = this.findClassesWithAnnotation(Entity.class);
        LOG.log(System.Logger.Level.DEBUG, () -> "Found JPA entities: " + String.valueOf(result));
        return result;
    }

    public Set<Class<?>> repositories() {
        Set<Class<?>> result = this.repositoriesStream().collect(Collectors.toUnmodifiableSet());
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected JPA repository interfaces: " + String.valueOf(result));
        return result;
    }

    public Set<Class<?>> embeddables() {
        Set<Class<?>> result = this.findClassesWithAnnotation(Embeddable.class);
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected JPA embeddables: " + String.valueOf(result));
        return result;
    }

    public <T extends DataRepository<?, ?>> Set<Class<?>> repositories(Class<T> filter) {
        Objects.requireNonNull(filter, "filter is required");
        return this.repositoriesStream().filter(filter::isAssignableFrom).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Class<?>> repositoriesStandard() {
        Set<Class<?>> result = this.enabledRepositoriesStreamMatching(this::isSupportedStandardInterface).collect(Collectors.toUnmodifiableSet());
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected standard JPA repository interfaces: " + String.valueOf(result));
        return result;
    }

    public Set<Class<?>> customRepositories() {
        Set<Class<?>> result = this.enabledRepositoriesStreamMatching(this::isNotSupportedStandardInterface).collect(Collectors.toUnmodifiableSet());
        LOG.log(System.Logger.Level.DEBUG, () -> "Detected custom JPA interfaces: " + String.valueOf(result));
        return result;
    }

    @Override
    protected boolean isSupportedEntityType(GeneralInterfaceModel entityType) {
        return null != entityType.getAnnotation(Entity.class);
    }

    @Override
    protected String getProviderName() {
        return "Eclipse_JNoSQL_Jakarta_Persistence";
    }
}

