/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.delivery;

import com.sun.istack.NotNull;
import com.sun.xml.ws.rx.rm.runtime.RmConfiguration;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.InOrderDeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import com.sun.xml.ws.rx.rm.runtime.delivery.SimpleDeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;

public final class DeliveryQueueBuilder {
    @NotNull
    private final RmConfiguration configuration;
    @NotNull
    private final Postman postman;
    @NotNull
    private final Postman.Callback deliveryCallback;
    private Sequence sequence;

    public static DeliveryQueueBuilder getBuilder(@NotNull RmConfiguration configuration, @NotNull Postman postman, @NotNull Postman.Callback deliveryCallback) {
        return new DeliveryQueueBuilder(configuration, postman, deliveryCallback);
    }

    private DeliveryQueueBuilder(@NotNull RmConfiguration configuration, @NotNull Postman postman, @NotNull Postman.Callback deliveryCallback) {
        assert (configuration != null);
        assert (postman != null);
        assert (deliveryCallback != null);
        this.configuration = configuration;
        this.postman = postman;
        this.deliveryCallback = deliveryCallback;
    }

    public void sequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public DeliveryQueue build() {
        if (this.configuration.getRmFeature().isOrderedDeliveryEnabled()) {
            boolean rejectOutOfOrderMessages = this.configuration.getRmFeature().isRejectOutOfOrderMessagesEnabled();
            return new InOrderDeliveryQueue(this.postman, this.deliveryCallback, this.sequence, this.configuration.getRmFeature().getDestinationBufferQuota(), rejectOutOfOrderMessages);
        }
        return new SimpleDeliveryQueue(this.postman, this.deliveryCallback);
    }
}

