/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.KeystoreManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.nio.charset.StandardCharsets;

public class MasterPasswordFileManager
extends KeystoreManager {
    private static final StringManager _strMgr = StringManager.getManager(MasterPasswordFileManager.class);

    private char[] getMasterPasswordPassword() throws RepositoryException {
        return "master-password".toCharArray();
    }

    protected void deleteMasterPasswordFile(RepositoryConfig config) {
        PEFileLayout layout = this.getFileLayout(config);
        File pwdFile = layout.getMasterPasswordFile();
        FileUtils.deleteFile((File)pwdFile);
    }

    protected void createMasterPasswordFile(RepositoryConfig config, String masterPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File pwdFile = layout.getMasterPasswordFile();
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
            p.setPasswordForAlias("master-password", masterPassword.getBytes(StandardCharsets.UTF_8));
            this.chmod("600", pwdFile);
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("masterPasswordFileNotCreated", (Object)pwdFile), ex);
        }
    }

    public String readMasterPasswordFile(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File pwdFile = layout.getMasterPasswordFile();
        if (!pwdFile.exists()) {
            return null;
        }
        try {
            PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
            return p.getPasswordForAlias("master-password");
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("masterPasswordFileNotRead", (Object)pwdFile), ex);
        }
    }

    protected void changeMasterPasswordInMasterPasswordFile(RepositoryConfig config, String newPassword, boolean saveMasterPassword) throws RepositoryException {
        this.deleteMasterPasswordFile(config);
        if (saveMasterPassword) {
            this.createMasterPasswordFile(config, newPassword);
        }
    }

    public void changeMasterPasswordInMasterPasswordFile(File pwdFile, String newPassword, boolean saveMasterPassword) throws RepositoryException {
        FileUtils.deleteFile((File)pwdFile);
        if (saveMasterPassword) {
            try {
                PasswordAdapter p = new PasswordAdapter(pwdFile.getAbsolutePath(), this.getMasterPasswordPassword());
                p.setPasswordForAlias("master-password", newPassword.getBytes(StandardCharsets.UTF_8));
                this.chmod("600", pwdFile);
            }
            catch (Exception ex) {
                throw new RepositoryException(_strMgr.getString("masterPasswordFileNotCreated", (Object)pwdFile), ex);
            }
        }
    }
}

