/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.tools.StandardLocation;
import org.jboss.jdeparser.ConfigIndent;
import org.jboss.jdeparser.EnumIntMap;
import org.jboss.jdeparser.Indent;

public final class FormatPreferences {
    private static final String PROPERTIES_FILE_NAME = "jdeparser.properties";
    private static final EnumIntMap<Indentation> DEFAULT_INDENTS;
    private static final EnumSet<Indentation> DEFAULT_ABS_INDENTS;
    private static final EnumMap<Space, SpaceType> DEFAULT_SPACE_TYPES;
    private static final EnumSet<Opt> DEFAULT_OPTS;
    private static final EnumMap<Wrapping, WrappingMode> DEFAULT_WRAPPING;
    private final EnumIntMap<Indentation> indents = new EnumIntMap<Indentation>(DEFAULT_INDENTS);
    private final EnumSet<Indentation> absoluteIndents = EnumSet.copyOf(DEFAULT_ABS_INDENTS);
    private final EnumMap<Space, SpaceType> spaceTypes = new EnumMap<Space, SpaceType>(DEFAULT_SPACE_TYPES);
    private final EnumSet<Opt> options = EnumSet.copyOf(DEFAULT_OPTS);
    private final EnumMap<Wrapping, WrappingMode> wrapping = new EnumMap<Wrapping, WrappingMode>(DEFAULT_WRAPPING);
    private int lineLength = 140;

    public FormatPreferences() {
    }

    public FormatPreferences(Properties properties) {
        this();
        ArrayList<String> l = new ArrayList<String>();
        for (String name : properties.stringPropertyNames()) {
            FormatPreferences.split(l, '.', name);
            String value = properties.getProperty(name);
            block6 : switch (l.size()) {
                case 1: {
                    switch (l.get(0)) {
                        case "line-length": {
                            try {
                                this.lineLength = Integer.parseInt(value);
                                break block6;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (l.get(0)) {
                        case "indent": {
                            int v;
                            try {
                                Indentation i = Indentation.valueOf(FormatPreferences.xf(l.get(1)));
                                v = Integer.parseInt(value);
                                this.indents.put(i, v);
                            }
                            catch (IllegalArgumentException i) {}
                            break block6;
                        }
                        case "wrapping": {
                            try {
                                Wrapping w = Wrapping.valueOf(FormatPreferences.xf(l.get(1)));
                                WrappingMode m = WrappingMode.valueOf(FormatPreferences.xf(value));
                                this.wrapping.put(w, m);
                            }
                            catch (IllegalArgumentException w) {}
                            break block6;
                        }
                        case "space": {
                            try {
                                Space s = Space.valueOf(FormatPreferences.xf(l.get(1)));
                                SpaceType t = SpaceType.valueOf(FormatPreferences.xf(value));
                                this.spaceTypes.put(s, t);
                            }
                            catch (IllegalArgumentException s) {}
                            break block6;
                        }
                        case "optimization": {
                            int v;
                            try {
                                Opt o = Opt.valueOf(FormatPreferences.xf(l.get(1)));
                                v = Boolean.parseBoolean(value) ? 1 : 0;
                                if (v != 0) {
                                    this.options.add(o);
                                    break block6;
                                }
                                this.options.remove((Object)o);
                                break block6;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    switch (l.get(0)) {
                        case "indent": {
                            switch (l.get(2)) {
                                case "absolute": {
                                    try {
                                        Indentation i = Indentation.valueOf(FormatPreferences.xf(l.get(1)));
                                        boolean v = Boolean.parseBoolean(value);
                                        if (v) {
                                            this.absoluteIndents.add(i);
                                            break block6;
                                        }
                                        this.absoluteIndents.remove((Object)i);
                                        break block6;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public FormatPreferences(ClassLoader classLoader) throws IOException {
        this(FormatPreferences.fnf(classLoader.getResourceAsStream(PROPERTIES_FILE_NAME)));
    }

    public FormatPreferences(Filer filer, String name) throws IOException {
        this(filer.getResource(StandardLocation.ANNOTATION_PROCESSOR_PATH, "", name).openInputStream());
    }

    public FormatPreferences(Filer filer) throws IOException {
        this(filer, PROPERTIES_FILE_NAME);
    }

    public FormatPreferences(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public FormatPreferences(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream, "utf-8"));
    }

    public FormatPreferences(Reader reader) throws IOException {
        this(FormatPreferences.load(reader));
    }

    private static InputStream fnf(InputStream stream) throws IOException {
        if (stream == null) {
            throw new FileNotFoundException(PROPERTIES_FILE_NAME);
        }
        return stream;
    }

    private static String xf(String name) {
        return name.toUpperCase(Locale.US).replace('-', '_');
    }

    private static void split(ArrayList<String> dest, char delim, String s) {
        dest.clear();
        int st = 0;
        int i = s.indexOf(delim);
        while (true) {
            if (i == -1) {
                dest.add(s.substring(st));
                return;
            }
            dest.add(s.substring(st, i));
            st = i + 1;
            i = s.indexOf(delim, st);
        }
    }

    private static Properties load(Reader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        return properties;
    }

    private <T> T def(T val, T def) {
        return val == null ? def : val;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getIndent(Indentation indentation) {
        return this.indents.get(indentation);
    }

    public int setIndent(Indentation indentation, int value) {
        return this.indents.put(indentation, value);
    }

    public boolean isIndentAbsolute(Indentation indentation) {
        return this.absoluteIndents.contains((Object)indentation);
    }

    public void setIndentAbsolute(Indentation indentation) {
        this.absoluteIndents.add(indentation);
    }

    public void clearIndentAbsolute(Indentation indentation) {
        this.absoluteIndents.remove((Object)indentation);
    }

    public SpaceType setSpaceType(Space space, SpaceType spaceType) {
        if (space == null) {
            throw new IllegalArgumentException("space is null");
        }
        if (spaceType == null) {
            throw new IllegalArgumentException("spaceType is null");
        }
        return this.def(this.spaceTypes.put(space, spaceType), SpaceType.NONE);
    }

    public void setAllSpaceTypes(SpaceType toType, Space ... spaces) {
        if (toType == null) {
            throw new IllegalArgumentException("toType is null");
        }
        if (spaces != null) {
            for (Space space : spaces) {
                this.def(this.spaceTypes.put(space, toType), SpaceType.NONE);
            }
        }
    }

    public SpaceType getSpaceType(Space space) {
        if (space == null) {
            throw new IllegalArgumentException("space is null");
        }
        return this.def(this.spaceTypes.get((Object)space), SpaceType.NONE);
    }

    public WrappingMode getWrapMode(Wrapping wrapping) {
        return this.def(this.wrapping.get((Object)wrapping), WrappingMode.WRAP_ONLY_IF_LONG);
    }

    public WrappingMode setWrapMode(Wrapping wrapping, WrappingMode mode) {
        return this.def(this.wrapping.put(wrapping, mode), WrappingMode.WRAP_ONLY_IF_LONG);
    }

    public void addOption(Opt ... opts) {
        Collections.addAll(this.options, opts);
    }

    public void removeOption(Opt ... opts) {
        for (Opt opt : opts) {
            this.options.remove((Object)opt);
        }
    }

    public boolean hasOption(Opt opt) {
        return this.options.contains((Object)opt);
    }

    static {
        EnumIntMap<Indentation> ind = new EnumIntMap<Indentation>(Indentation.class, 0);
        ind.put(Indentation.LINE, 4);
        ind.put(Indentation.LINE_CONTINUATION, 4);
        ind.put(Indentation.MEMBERS_TOP_LEVEL, 4);
        ind.put(Indentation.LABELS, 0);
        ind.put(Indentation.CASE_LABELS, 0);
        ind.put(Indentation.HTML_TAG, 2);
        DEFAULT_INDENTS = ind;
        DEFAULT_ABS_INDENTS = EnumSet.noneOf(Indentation.class);
        EnumMap<Space, SpaceType> spaceTypes = new EnumMap<Space, SpaceType>(Space.class);
        spaceTypes.put(Space.AFTER_COMMA, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_COMMA_TYPE_ARGUMENT, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_COMMA_ENUM_CONSTANT, SpaceType.NEWLINE);
        spaceTypes.put(Space.AFTER_LABEL, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_IF, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_FOR, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_WHILE, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_SWITCH, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_TRY, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_CATCH, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_SYNCHRONIZED, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_PAREN_CAST, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_ANNOTATION_ARRAY_INIT, SpaceType.NONE);
        spaceTypes.put(Space.BEFORE_BRACE_ARRAY_INIT, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_CATCH, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_CLASS, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_DO, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_ELSE, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_FINALLY, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_FOR, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_IF, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_METHOD, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_SWITCH, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_SYNCHRONIZE, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_TRY, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_BRACE_WHILE, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_SEMICOLON, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_KEYWORD_ELSE, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_KEYWORD_WHILE, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_KEYWORD_CATCH, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_KEYWORD_FINALLY, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_ADDITIVE, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_MULTIPLICATIVE, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_SHIFT, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_BITWISE, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_ASSIGN, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_LOGICAL, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_EQUALITY, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_RANGE, SpaceType.SPACE);
        spaceTypes.put(Space.AROUND_ARROW, SpaceType.SPACE);
        spaceTypes.put(Space.WITHIN_BRACES_CODE, SpaceType.NEWLINE);
        spaceTypes.put(Space.WITHIN_BRACES_ARRAY_INIT, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_TERNARY_Q, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_TERNARY_Q, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_TERNARY_COLON, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_TERNARY_COLON, SpaceType.SPACE);
        spaceTypes.put(Space.BEFORE_COLON, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_COLON, SpaceType.SPACE);
        spaceTypes.put(Space.AFTER_ANNOTATION, SpaceType.NEWLINE);
        spaceTypes.put(Space.AFTER_PARAM_ANNOTATION, SpaceType.SPACE);
        DEFAULT_SPACE_TYPES = spaceTypes;
        DEFAULT_OPTS = EnumSet.of(Opt.COMPACT_INIT_ONLY_CLASS);
        EnumMap<Wrapping, WrappingMode> wm = new EnumMap<Wrapping, WrappingMode>(Wrapping.class);
        wm.put(Wrapping.EXCEPTION_LIST, WrappingMode.WRAP_ONLY_IF_LONG);
        DEFAULT_WRAPPING = wm;
    }

    public static enum Opt {
        ENUM_TRAILING_COMMA,
        ENUM_EMPTY_PARENS,
        COMPACT_INIT_ONLY_CLASS,
        DROP_UNUSED_LABELS;

    }

    public static enum WrappingMode {
        ALWAYS_WRAP,
        WRAP_ONLY_IF_LONG,
        NEVER;

    }

    public static enum Wrapping {
        EXCEPTION_LIST;

    }

    public static enum Indentation {
        MEMBERS_TOP_LEVEL,
        LABELS,
        CASE_LABELS,
        LINE_CONTINUATION,
        LINE,
        HTML_TAG;

        private final Indent indent = new ConfigIndent(this);

        Indent getIndent() {
            return this.indent;
        }
    }

    public static enum Space {
        BEFORE_PAREN,
        BEFORE_STATEMENT,
        BEFORE_PAREN_METHOD_CALL,
        BEFORE_PAREN_METHOD_DECLARATION,
        BEFORE_PAREN_IF,
        BEFORE_PAREN_FOR,
        BEFORE_PAREN_WHILE,
        BEFORE_PAREN_SWITCH,
        BEFORE_PAREN_TRY,
        BEFORE_PAREN_CATCH,
        BEFORE_PAREN_SYNCHRONIZED,
        BEFORE_PAREN_ANNOTATION_PARAM,
        BEFORE_PAREN_CAST,
        AROUND_OPERATORS,
        AROUND_ASSIGN,
        AROUND_LOGICAL,
        AROUND_EQUALITY,
        AROUND_RANGE,
        AROUND_BITWISE,
        AROUND_ADDITIVE,
        AROUND_MULTIPLICATIVE,
        AROUND_SHIFT,
        AROUND_ARROW,
        AROUND_METHOD_REF,
        AT_UNARY,
        BEFORE_BRACE,
        BEFORE_BRACE_CLASS,
        BEFORE_BRACE_METHOD,
        BEFORE_BRACE_IF,
        BEFORE_BRACE_ELSE,
        BEFORE_BRACE_FOR,
        BEFORE_BRACE_WHILE,
        BEFORE_BRACE_DO,
        BEFORE_BRACE_SWITCH,
        BEFORE_BRACE_TRY,
        BEFORE_BRACE_CATCH,
        BEFORE_BRACE_FINALLY,
        BEFORE_BRACE_SYNCHRONIZE,
        BEFORE_BRACE_ARRAY_INIT,
        BEFORE_BRACE_ANNOTATION_ARRAY_INIT,
        BEFORE_KEYWORD_ELSE,
        BEFORE_KEYWORD_WHILE,
        BEFORE_KEYWORD_CATCH,
        BEFORE_KEYWORD_FINALLY,
        WITHIN_BRACES_CODE,
        WITHIN_BRACES_EMPTY,
        WITHIN_BRACES_ARRAY_INIT,
        WITHIN_BRACKETS,
        WITHIN_PAREN_EXPR,
        WITHIN_PAREN_METHOD_CALL,
        WITHIN_PAREN_METHOD_CALL_EMPTY,
        WITHIN_PAREN_METHOD_DECLARATION,
        WITHIN_PAREN_METHOD_DECLARATION_EMPTY,
        WITHIN_PAREN_IF,
        WITHIN_PAREN_FOR,
        WITHIN_PAREN_WHILE,
        WITHIN_PAREN_SWITCH,
        WITHIN_PAREN_TRY,
        WITHIN_PAREN_CATCH,
        WITHIN_PAREN_SYNCHRONIZED,
        WITHIN_PAREN_CAST,
        WITHIN_PAREN_ANNOTATION,
        BEFORE_TERNARY_Q,
        AFTER_TERNARY_Q,
        BEFORE_TERNARY_COLON,
        AFTER_TERNARY_COLON,
        AFTER_COMMA_TYPE_ARGUMENT,
        BEFORE_COMMA,
        AFTER_COMMA,
        BEFORE_COLON,
        AFTER_COLON,
        AFTER_COMMA_ENUM_CONSTANT,
        BEFORE_SEMICOLON,
        AFTER_SEMICOLON,
        AFTER_CAST,
        AFTER_LABEL,
        AFTER_ANNOTATION,
        AFTER_PARAM_ANNOTATION;

    }

    public static enum SpaceType {
        NONE,
        SPACE,
        NEWLINE;

    }
}

