/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelegatingJobXMLLoaderServiceImpl
implements IJobXMLLoaderService {
    private static final Logger logger = Logger.getLogger(DelegatingBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = DelegatingBatchArtifactFactoryImpl.class.getName();
    protected static IJobXMLLoaderService preferredJobXmlLoader = ServicesManagerImpl.getInstance().getPreferredJobXMLLoaderService();
    public static final String PREFIX = "META-INF/batch-jobs/";

    @Override
    public String loadJSL(String id) {
        String method = "loadJob";
        logger.entering(CLASSNAME, method);
        String jobXML = null;
        if (!preferredJobXmlLoader.getClass().equals(this.getClass())) {
            jobXML = preferredJobXmlLoader.loadJSL(id);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "No preferred job xml loader is detected in configuration");
        }
        if (jobXML != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Preferred job xml loader loaded job with id " + id + ".");
            }
            return jobXML;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Preferred job xml loader failed to load " + id + ". Defaulting to " + PREFIX);
        }
        if ((jobXML = DelegatingJobXMLLoaderServiceImpl.loadJobFromBatchJobs(id)) == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Failed to load " + id + " from " + PREFIX);
            }
            throw new BatchContainerServiceException("Could not load job xml with id: " + id);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Loaded job xml with " + id + " from " + PREFIX);
        }
        return jobXML;
    }

    private static String loadJobFromBatchJobs(String id) {
        String relativePath;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        InputStream stream = tccl.getResourceAsStream(relativePath = PREFIX + id + ".xml");
        if (stream == null) {
            throw new BatchContainerRuntimeException(new FileNotFoundException("Cannot find an XML file under META-INF/batch-jobs/ with the following name " + id + ".xml"));
        }
        return DelegatingJobXMLLoaderServiceImpl.readJobXML(stream);
    }

    private static String readJobXML(InputStream stream) {
        StringBuffer out = new StringBuffer();
        try {
            int i;
            byte[] b = new byte[4096];
            while ((i = stream.read(b)) != -1) {
                out.append(new String(b, 0, i));
            }
        }
        catch (FileNotFoundException e) {
            throw new BatchContainerServiceException(e);
        }
        catch (IOException e) {
            throw new BatchContainerServiceException(e);
        }
        return out.toString();
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

