/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.CommandLine;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.admin.launcher.GFLauncherNativeHelper;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.glassfish.embeddable.GlassFishVariable;

class GlassFishMainLauncher
extends GFLauncher {
    private static final System.Logger LOG = System.getLogger(GlassFishMainLauncher.class.getName());
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.GlassFishMain";
    private final Long pidBeforeRestart = GlassFishMainLauncher.resolvePidBeforeRestart();
    private Map<String, String> asenvProps;
    private Path javaExe;
    private JavaConfig domainXMLjavaConfig;
    private List<String> domainXMLjavaConfigDebugOptions;
    private File adminFileRealmKeyFile;
    private boolean secureAdminEnabled;
    private Path logFile;
    private boolean needsAutoUpgrade;
    private boolean needsManualUpgrade;
    private Profiler domainXMLJavaConfigProfiler;
    private JvmOptions jvmOptions;
    private Integer debugPort;
    private boolean debugSuspend;
    private boolean setup;
    private File modulepath;
    private File[] classpath;

    GlassFishMainLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    public Long getPidBeforeRestart() {
        return this.pidBeforeRestart;
    }

    @Override
    public File getAdminRealmKeyFile() {
        return this.adminFileRealmKeyFile;
    }

    @Override
    public boolean isSecureAdminEnabled() {
        return this.secureAdminEnabled;
    }

    @Override
    public Integer getDebugPort() {
        return this.debugPort;
    }

    @Override
    public boolean isSuspendEnabled() {
        return this.getDebugPort() != null && this.debugSuspend;
    }

    @Override
    public Path getLogFile() {
        return this.logFile;
    }

    @Override
    public final boolean needsAutoUpgrade() {
        return this.needsAutoUpgrade;
    }

    @Override
    public final boolean needsManualUpgrade() {
        return this.needsManualUpgrade;
    }

    @Override
    public void setup() throws GFLauncherException, MiniXmlParserException {
        if (this.setup) {
            throw new IllegalStateException("The setup() was already executed.");
        }
        this.setup = true;
        GFLauncherInfo callerParameters = this.getParameters();
        callerParameters.setup();
        this.setupLogLevels(callerParameters.isVerbose());
        this.asenvProps = this.getAsEnvConfReader(callerParameters, this.isFakeLaunch()).getProps();
        MiniXmlParser domainXML = new MiniXmlParser(callerParameters.getConfigFile(), callerParameters.getInstanceName());
        String domainName = domainXML.getDomainName();
        if (GFLauncherUtils.ok((String)domainName)) {
            callerParameters.setDomainName(domainName);
        }
        callerParameters.setXmlAdminAddresses(domainXML.getAdminAddresses());
        this.domainXMLjavaConfig = new JavaConfig(domainXML.getJavaConfig());
        this.domainXMLJavaConfigProfiler = this.createProfiler(domainXML);
        this.jvmOptions = this.createJvmOptions(callerParameters, this.domainXMLJavaConfigProfiler, domainXML.getJvmOptions());
        this.secureAdminEnabled = domainXML.getSecureAdminEnabled();
        if (domainXML.isMonitoringEnabled()) {
            this.setupMonitoring(callerParameters.getInstallDir());
        }
        Map domainXMLSystemProperties = domainXML.getSystemProperties();
        this.asenvProps.put(GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName(), callerParameters.getInstanceRootDir().getPath());
        String javaHome = this.domainXMLjavaConfig.getJavaHome();
        if (GFLauncherUtils.ok((String)javaHome) && !javaHome.trim().equals(GlassFishVariable.JAVA_ROOT.toExpression())) {
            this.asenvProps.put(GlassFishVariable.JAVA_ROOT.getPropertyName(), javaHome);
        }
        this.domainXMLjavaConfigDebugOptions = this.getDebugOptionsFromDomainXMLJavaConfig(callerParameters);
        this.setupDebugging(this.domainXMLjavaConfigDebugOptions);
        domainXML.setupConfigDir(callerParameters.getConfigDir(), callerParameters.getInstallDir());
        TokenResolver resolver = this.createTokenResolver(domainXMLSystemProperties);
        this.resolveAllTokens(resolver);
        this.adminFileRealmKeyFile = GlassFishMainLauncher.resolveAdminFileRealmKeyFile(domainXML, resolver);
        this.logFile = GlassFishMainLauncher.resolveLogFile(domainXML.getLogFilename(), callerParameters, resolver);
        GFLauncherLogger.addLogFileHandler(this.logFile);
        this.javaExe = this.resolveJavaExecutable();
        Path installRoot = new File(this.asenvProps.get(GlassFishVariable.INSTALL_ROOT.getPropertyName())).toPath();
        this.modulepath = installRoot.resolve(Path.of("lib", "bootstrap")).toAbsolutePath().normalize().toFile();
        this.classpath = this.createClasspath();
        this.setCommandLine(this.prepareCommandLine(callerParameters));
        this.needsAutoUpgrade = !domainXML.hasNetworkConfig();
        this.needsManualUpgrade = !domainXML.hasDefaultConfig();
        this.setupUpgradeSecurity(callerParameters);
        this.renameOsgiCache(callerParameters);
    }

    private CommandLine prepareCommandLine(GFLauncherInfo callerParameters) throws GFLauncherException {
        boolean useScript = !callerParameters.isVerboseOrWatchdog() && GlassFishMainLauncher.isSurviveWinUserSession();
        CommandLine cmdLine = new CommandLine(useScript ? CommandLine.CommandFormat.Script : CommandLine.CommandFormat.ProcessBuilder);
        cmdLine.append(this.javaExe);
        cmdLine.appendModulePath(this.modulepath);
        if (this.classpath.length > 0) {
            cmdLine.appendClassPath(this.classpath);
        }
        GlassFishMainLauncher.addIgnoreNull(cmdLine, this.domainXMLjavaConfigDebugOptions);
        String cliStartTime = System.getProperty("WALL_CLOCK_START");
        if (cliStartTime != null) {
            cmdLine.append("-DWALL_CLOCK_START=" + cliStartTime);
        }
        if (this.getDebugPort() != null) {
            cmdLine.appendSystemOption("com.sun.aas.debugMode", Boolean.TRUE.toString());
        }
        this.jvmOptions.toList().forEach(cmdLine::appendJavaOption);
        GFLauncherNativeHelper nativeHelper = new GFLauncherNativeHelper(callerParameters, this.domainXMLjavaConfig, this.jvmOptions, this.domainXMLJavaConfigProfiler);
        cmdLine.appendNativeLibraryPath(nativeHelper.getNativePath());
        cmdLine.append(MAIN_CLASS);
        try {
            GlassFishMainLauncher.addIgnoreNull(cmdLine, callerParameters.getArgsAsList());
        }
        catch (GFLauncherException gfle) {
            throw gfle;
        }
        catch (Exception e) {
            throw new GFLauncherException(e);
        }
        return cmdLine;
    }

    private ASenvPropertyReader getAsEnvConfReader(GFLauncherInfo callerParameters, boolean fakeLaunch) {
        return fakeLaunch ? new ASenvPropertyReader(callerParameters.getInstallDir()) : new ASenvPropertyReader();
    }

    private Path resolveJavaExecutable() throws GFLauncherException {
        Path javaFromDomainXml = this.getJavaExecutable(this.domainXMLjavaConfig.getJavaHome());
        if (javaFromDomainXml != null) {
            return javaFromDomainXml;
        }
        Path javaFromAsenv = this.getJavaExecutable(this.asenvProps.get(GlassFishVariable.JAVA_ROOT.getPropertyName()));
        if (javaFromAsenv != null) {
            return javaFromAsenv;
        }
        throw new GFLauncherException("nojvm");
    }

    private Path getJavaExecutable(String filename) {
        if (filename == null) {
            return null;
        }
        File javaDir = new File(filename);
        if (!javaDir.isDirectory()) {
            return null;
        }
        File javaFile = GFLauncherUtils.isWindows() ? new File(javaDir, "bin/java.exe") : new File(javaDir, "bin/java");
        if (javaFile.exists()) {
            return javaFile.toPath().toAbsolutePath();
        }
        return null;
    }

    private TokenResolver createTokenResolver(Map<String, String> domainXMLSystemProperties) {
        HashMap<String, String> all = new HashMap<String, String>();
        all.putAll(this.asenvProps);
        all.putAll(CollectionUtils.propertiesToStringMap((Properties)System.getProperties()));
        all.putAll(domainXMLSystemProperties);
        all.putAll(this.jvmOptions.getCombinedMap());
        all.putAll(this.domainXMLJavaConfigProfiler.getConfig());
        if (!GlassFishMainLauncher.isEnvVarExpansionDisabled(all)) {
            if (GlassFishMainLauncher.isPreferEnvOverProperties(all).booleanValue()) {
                all.putAll(System.getenv());
                this.replacePropertiesWithEnvVars(this.jvmOptions.xProps);
                this.replacePropertiesWithEnvVars(this.jvmOptions.xxProps);
                this.replacePropertiesWithEnvVars(this.jvmOptions.plainProps);
                this.replacePropertiesWithEnvVars(this.jvmOptions.longProps);
                this.replacePropertiesWithEnvVars(this.jvmOptions.sysProps);
            } else {
                System.getenv().forEach((name, value) -> all.putIfAbsent((String)name, (String)value));
            }
        }
        return new TokenResolver(all);
    }

    private void resolveAllTokens(TokenResolver resolver) {
        resolver.resolve(this.jvmOptions.xProps);
        resolver.resolve(this.jvmOptions.xxProps);
        resolver.resolve(this.jvmOptions.plainProps);
        resolver.resolve(this.jvmOptions.longProps);
        resolver.resolve(this.jvmOptions.sysProps);
        resolver.resolve(this.domainXMLjavaConfig.getMap());
        resolver.resolve(this.domainXMLJavaConfigProfiler.getConfig());
        resolver.resolve(this.domainXMLjavaConfigDebugOptions);
    }

    private void replacePropertiesWithEnvVars(Map<String, String> properties) {
        Pattern invalidEnvVarCharsPattern = Pattern.compile("[^_0-9a-zA-Z]");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String envValue = System.getenv(entry.getKey());
            if (envValue != null) {
                entry.setValue(envValue);
                continue;
            }
            String sanitizedKey = invalidEnvVarCharsPattern.matcher(entry.getKey()).replaceAll("_");
            envValue = System.getenv(sanitizedKey);
            if (envValue != null) {
                entry.setValue(envValue);
                continue;
            }
            envValue = System.getenv(sanitizedKey.toUpperCase());
            if (envValue == null) continue;
            entry.setValue(envValue);
        }
    }

    private Profiler createProfiler(MiniXmlParser domainXML) throws MiniXmlParserException {
        return new Profiler(domainXML.getProfilerConfig(), domainXML.getProfilerJvmOptions(), domainXML.getProfilerSystemProperties());
    }

    private JvmOptions createJvmOptions(GFLauncherInfo callerParameters, Profiler profiler, List<String> domainXmlJvmOptions) throws GFLauncherException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(GlassFishVariable.INSTALL_ROOT.getSystemPropertyName(), callerParameters.getInstallDir().getAbsolutePath());
        props.put(GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName(), callerParameters.getInstanceRootDir().getAbsolutePath());
        ArrayList<String> rawJvmOptions = new ArrayList<String>(domainXmlJvmOptions);
        rawJvmOptions.addAll(this.propsToJvmOptions(props));
        if (profiler.isEnabled()) {
            rawJvmOptions.addAll(profiler.getJvmOptions());
        }
        JvmOptions jvm = new JvmOptions(rawJvmOptions);
        if (callerParameters.isDropInterruptedCommands()) {
            jvm.sysProps.put("org.glassfish.job-manager.drop-interrupted-commands", Boolean.TRUE.toString());
        }
        return jvm;
    }

    private void setupUpgradeSecurity(GFLauncherInfo callerParameters) throws GFLauncherException {
        if (callerParameters.isUpgrade() && this.jvmOptions.sysProps.containsKey("java.security.manager")) {
            LOG.log(System.Logger.Level.INFO, "Will copy glassfish/lib/templates/server.policy file to domain before upgrading.");
            Path source = callerParameters.getInstallDir().toPath().resolve(Path.of("lib", "templates", "server.policy"));
            Path target = callerParameters.getConfigDir().toPath().resolve("server.policy");
            try {
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioe) {
                throw new GFLauncherException("Could not copy server.policy to domain. You may need to turn off the security manager before upgrading. " + ioe.getMessage(), ioe);
            }
        }
    }

    private void renameOsgiCache(GFLauncherInfo callerParameters) throws GFLauncherException {
        if (callerParameters.isUpgrade()) {
            File osgiCacheDir = new File(callerParameters.getDomainRootDir(), "osgi-cache");
            File backupOsgiCacheDir = new File(callerParameters.getDomainRootDir(), "osgi-cache-" + System.currentTimeMillis());
            if (osgiCacheDir.exists() && !backupOsgiCacheDir.exists()) {
                if (FileUtils.renameFile((File)osgiCacheDir, (File)backupOsgiCacheDir)) {
                    GFLauncherLogger.fine("rename_osgi_cache_succeeded", osgiCacheDir, backupOsgiCacheDir);
                } else {
                    throw new GFLauncherException("rename_osgi_cache_failed", osgiCacheDir, backupOsgiCacheDir);
                }
            }
        }
    }

    private void setupMonitoring(File installDirr) {
        Set<String> plainKeys = this.jvmOptions.plainProps.keySet();
        for (String key : plainKeys) {
            if (!key.startsWith("javaagent:") || (key = key.replace('\\', '/')).indexOf("flashlight-agent.jar") < 0) continue;
            return;
        }
        try {
            this.jvmOptions.plainProps.put(GlassFishMainLauncher.getMonitoringAgentJvmOptionString(installDirr), null);
        }
        catch (GFLauncherException gFLauncherException) {
            // empty catch block
        }
    }

    private static Boolean isPreferEnvOverProperties(Map<String, String> properties) {
        return Boolean.parseBoolean(properties.get("org.glassfish.variableExpansion.envPreferred"));
    }

    private static boolean isEnvVarExpansionDisabled(Map<String, String> all) {
        return Boolean.parseBoolean(all.get("org.glassfish.variableExpansion.envDisabled"));
    }

    private List<String> getDebugOptionsFromDomainXMLJavaConfig(GFLauncherInfo callerParameters) {
        if (callerParameters.isDebug() || callerParameters.isSuspend() || this.domainXMLjavaConfig.isDebugEnabled()) {
            if (!callerParameters.isSuspend()) {
                return this.domainXMLjavaConfig.getDebugOptions();
            }
            return this.domainXMLjavaConfig.getDebugOptions().stream().filter(e -> e.startsWith("-agentlib:jdwp")).map(e -> e.replace("suspend=n", "suspend=y")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<String> propsToJvmOptions(Map<String, String> map) {
        ArrayList<String> sysProps = new ArrayList<String>();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            String jvm = "-D" + name;
            if (value != null) {
                jvm = jvm + "=" + value;
            }
            sysProps.add(jvm);
        }
        return sysProps;
    }

    private void setupLogLevels(boolean verbose) {
        if (verbose) {
            GFLauncherLogger.setConsoleLevel(Level.INFO);
        } else {
            GFLauncherLogger.setConsoleLevel(Level.WARNING);
        }
    }

    private File[] createClasspath() {
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(this.domainXMLjavaConfig.getPrefixClasspath());
        all.addAll(this.domainXMLJavaConfigProfiler.getClasspath());
        all.addAll(this.domainXMLjavaConfig.getSystemClasspath());
        all.addAll(this.domainXMLjavaConfig.getEnvClasspath());
        all.addAll(this.domainXMLjavaConfig.getSuffixClasspath());
        return (File[])all.toArray(File[]::new);
    }

    private void setupDebugging(List<String> domainXMLjavaConfigDebugOptions) {
        for (String option : domainXMLjavaConfigDebugOptions) {
            String[] attributes;
            if (!option.startsWith("-agentlib:jdwp")) continue;
            for (String attribute : attributes = option.substring(10).split(",")) {
                if (attribute.startsWith("address=")) {
                    try {
                        this.debugPort = Integer.parseInt(attribute.substring(10));
                    }
                    catch (NumberFormatException ex) {
                        this.debugPort = null;
                    }
                }
                if (!attribute.startsWith("suspend=")) continue;
                try {
                    this.debugSuspend = attribute.substring(8).toLowerCase(Locale.getDefault()).equals("y");
                }
                catch (Exception ex) {
                    this.debugSuspend = false;
                }
            }
        }
    }

    private static String getMonitoringAgentJvmOptionString(File installDir) throws GFLauncherException {
        File libMonDir = new File(installDir, "lib/monitor");
        File flashlightJarFile = new File(libMonDir, "flashlight-agent.jar");
        if (flashlightJarFile.isFile()) {
            return "javaagent:" + String.valueOf(flashlightJarFile.toPath().toAbsolutePath().normalize());
        }
        GFLauncherLogger.warning("NCLS-GFLAUNCHER-00003", flashlightJarFile);
        throw new GFLauncherException("no_flashlight_agent", flashlightJarFile);
    }

    private static File resolveAdminFileRealmKeyFile(MiniXmlParser domainXML, TokenResolver resolver) {
        Map realmprops = domainXML.getAdminRealmProperties();
        if (realmprops == null) {
            return null;
        }
        String classname = (String)realmprops.get("classname");
        String keyfile = (String)realmprops.get("file");
        if (keyfile == null || !"com.sun.enterprise.security.auth.realm.file.FileRealm".equals(classname)) {
            return null;
        }
        return new File(resolver.resolve(keyfile));
    }

    private static Path resolveLogFile(String domainXmlLogFile, GFLauncherInfo callerParameters, TokenResolver resolver) throws GFLauncherException {
        String stringPath = GFLauncherUtils.ok((String)domainXmlLogFile) ? domainXmlLogFile : "logs/server.log";
        Path logFilePath = Path.of(resolver.resolve(stringPath), new String[0]);
        if (logFilePath.isAbsolute()) {
            return logFilePath.normalize();
        }
        return callerParameters.getInstanceRootDir().toPath().resolve(logFilePath).normalize();
    }

    private static Long resolvePidBeforeRestart() {
        String pid = System.getProperty("AS_RESTART_PREVIOUS_PID");
        if (pid == null) {
            return null;
        }
        try {
            return Long.valueOf(pid);
        }
        catch (NumberFormatException e) {
            LOG.log(System.Logger.Level.WARNING, "Cannot parse pid {0} required for waiting for the death of the parent process.", pid);
            return null;
        }
    }

    private static boolean isSurviveWinUserSession() {
        String surviveSessionValue = System.getenv("AS_SURVIVE_WIN_USER_SESSION");
        if (surviveSessionValue == null) {
            return GlassFishMainLauncher.isWindows() && GlassFishMainLauncher.isOverSSHSession();
        }
        return Boolean.parseBoolean(surviveSessionValue);
    }

    private static boolean isOverSSHSession() {
        return System.getenv("SSH_CLIENT") != null || System.getenv("SSH_CONNECTION") != null || System.getenv("SSH_TTY") != null;
    }

    private static void addIgnoreNull(CommandLine command, Collection<String> values) {
        if (values != null && !values.isEmpty()) {
            values.forEach(command::append);
        }
    }
}

