/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.deployment.Addressing;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.RespectBinding;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.DocumentAddressResolver;
import com.sun.xml.ws.api.server.PortAddressResolver;
import com.sun.xml.ws.api.server.SDDocument;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.resources.ModelerMessages;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import jakarta.inject.Inject;
import jakarta.xml.ws.RespectBindingFeature;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.soap.AddressingFeature;
import jakarta.xml.ws.soap.MTOMFeature;
import jakarta.xml.ws.spi.WebServiceFeatureAnnotation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.namespace.QName;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.webservices.JAXWSAdapterRegistry;
import org.glassfish.webservices.JAXWSServiceDelegate;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.WSContainerResolver;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.WsUtil;
import org.jvnet.hk2.annotations.Service;

@Service
public class WebServiceReferenceManagerImpl
implements WebServiceReferenceManager {
    private static final Logger LOG = LogUtils.getLogger();
    @Inject
    private ServerEnvironment serverEnv;

    public Object getWSContextObject() {
        return new WebServiceContextImpl();
    }

    public Object resolveWSReference(ServiceReferenceDescriptor desc, Context context) throws NamingException {
        Class<?> serviceInterfaceClass = null;
        Object returnObj = null;
        WsUtil wsUtil = new WsUtil();
        InitialContext iContext = new InitialContext();
        if (desc.hasLookupName()) {
            return iContext.lookup(desc.getLookupName().toString());
        }
        try {
            WSContainerResolver.set(desc);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            serviceInterfaceClass = cl.loadClass(desc.getServiceInterface());
            this.resolvePortComponentLinks(desc);
            jakarta.xml.ws.Service jaxwsDelegate = null;
            Object injValue = null;
            if (jakarta.xml.ws.Service.class.isAssignableFrom(serviceInterfaceClass) && !jakarta.xml.ws.Service.class.equals(serviceInterfaceClass)) {
                injValue = this.initiateInstance(serviceInterfaceClass, desc);
            } else if (desc.isInjectable()) {
                Class<?> targetClass;
                InjectionTarget target = (InjectionTarget)desc.getInjectionTargets().iterator().next();
                Class<?> serviceType = null;
                if (target.isFieldInjectable()) {
                    Field f = target.getField();
                    if (f == null) {
                        String fName = target.getFieldName();
                        targetClass = cl.loadClass(target.getClassName());
                        try {
                            f = targetClass.getDeclaredField(fName);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (f != null) {
                        serviceType = f.getType();
                    }
                }
                if (target.isMethodInjectable()) {
                    Method m = target.getMethod();
                    if (m == null) {
                        String mName = target.getMethodName();
                        targetClass = cl.loadClass(target.getClassName());
                        try {
                            m = targetClass.getDeclaredMethod(mName, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (m != null && m.getParameterTypes().length == 1) {
                        serviceType = m.getParameterTypes()[0];
                    }
                }
                if (serviceType != null) {
                    Class<?> loadedSvcClass = cl.loadClass(serviceType.getCanonicalName());
                    injValue = this.initiateInstance(loadedSvcClass, desc);
                }
            }
            if (injValue == null) {
                jakarta.xml.ws.Service svc = jakarta.xml.ws.Service.create((URL)new WsUtil().privilegedGetServiceRefWsdl(desc), (QName)desc.getServiceName());
                jaxwsDelegate = new JAXWSServiceDelegate(desc, svc, cl);
            }
            if (jakarta.xml.ws.Service.class.isAssignableFrom(serviceInterfaceClass)) {
                jakarta.xml.ws.Service service;
                jakarta.xml.ws.Service service2 = service = injValue == null ? jaxwsDelegate : (jakarta.xml.ws.Service)injValue;
                if (service != null) {
                    wsUtil.configureJAXWSClientHandlers(service, desc);
                }
                if (injValue != null && desc.getInjectionTargetType() != null) {
                    Class<?> requestedPortType = service.getClass().getClassLoader().loadClass(desc.getInjectionTargetType());
                    ArrayList<WebServiceFeature> wsFeatures = this.getWebServiceFeatures(desc);
                    injValue = wsFeatures.size() > 0 ? service.getPort(requestedPortType, wsFeatures.toArray(new WebServiceFeature[wsFeatures.size()])) : service.getPort(requestedPortType);
                }
            }
            if (jaxwsDelegate != null) {
                returnObj = jaxwsDelegate;
            } else if (injValue != null) {
                returnObj = injValue;
            }
        }
        catch (PrivilegedActionException pae) {
            LOG.log(Level.WARNING, "AS-WSJSR109IMPL-00050", pae);
            NamingException ne = new NamingException();
            ne.initCause(pae.getCause());
            throw ne;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "AS-WSJSR109IMPL-00050", e);
            NamingException ne = new NamingException();
            ne.initCause(e);
            throw ne;
        }
        finally {
            WSContainerResolver.unset();
        }
        return returnObj;
    }

    private Object initiateInstance(Class<?> svcClass, ServiceReferenceDescriptor desc) throws Exception {
        WsUtil wsu = new WsUtil();
        URL wsdlFile = wsu.privilegedGetServiceRefWsdl(desc);
        Constructor<?> cons = svcClass.getConstructor(URL.class, QName.class);
        try {
            return cons.newInstance(wsdlFile, desc.getServiceName());
        }
        catch (InvocationTargetException e) {
            LOG.log(Level.CONFIG, "Service constructor failed, now we will try to generate the WSDL on our own, if it is possible.", e);
            URL optionalWsdlURL = this.generateWsdlFile(desc);
            if (optionalWsdlURL == null) {
                throw e;
            }
            return cons.newInstance(optionalWsdlURL, desc.getServiceName());
        }
    }

    private File getOptionalWsdlLocation(ServiceReferenceDescriptor desc) {
        File generatedXmlDir = this.serverEnv.getApplicationGeneratedXMLPath();
        return new File(new File(new File(generatedXmlDir, VersioningUtils.getRepositoryName((String)desc.getBundleDescriptor().getApplication().getRegistrationName())), desc.getServiceLocalPart()), "wsdl.xml");
    }

    private void createParentDirs(File optionalWsdlLocation) throws IOException {
        File parent = optionalWsdlLocation.getParentFile();
        this.mkDirs(parent);
    }

    private URL generateWsdlFile(ServiceReferenceDescriptor desc) throws IOException {
        File optionalWsdl = this.getOptionalWsdlLocation(desc);
        if (optionalWsdl.exists()) {
            LOG.log(Level.FINEST, "The file already exists, so I am returning it: {0}", optionalWsdl);
            return optionalWsdl.toURI().toURL();
        }
        this.createParentDirs(optionalWsdl);
        ServletAdapter targetEndpoint = this.getServletAdapter(desc);
        if (targetEndpoint == null) {
            LOG.log(Level.WARNING, "Target endpoint's servlet adapter wasn't found, I cannot generate the wsdl, returning null.");
            return null;
        }
        ServiceDefinition serviceDefinition = targetEndpoint.getServiceDefinition();
        SDDocument wsdlDocument = null;
        for (SDDocument xsdnum : serviceDefinition) {
            if (xsdnum != serviceDefinition.getPrimary()) continue;
            wsdlDocument = xsdnum;
            break;
        }
        if (wsdlDocument == null) {
            LOG.log(Level.FINEST, "Service definition document wasn't found, I cannot generate the wsdl, returning null.");
            return null;
        }
        LOG.log(Level.INFO, "Generating the WSDL: {0}", optionalWsdl);
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(optionalWsdl));){
            PortAddressResolver portAddressResolver = targetEndpoint.getPortAddressResolver(WebServiceReferenceManagerImpl.getBaseAddress(desc.getWsdlFileUrl()));
            DocumentAddressResolver resolver = targetEndpoint.getDocumentAddressResolver(portAddressResolver);
            wsdlDocument.writeTo(portAddressResolver, resolver, (OutputStream)outputStream);
        }
        return optionalWsdl.toURI().toURL();
    }

    private ServletAdapter getServletAdapter(ServiceReferenceDescriptor desc) {
        if (!(desc.getBundleDescriptor() instanceof WebBundleDescriptor)) {
            return this.getServletAdapterBasedOnWsdlUrl(desc);
        }
        WebBundleDescriptor webBundle = (WebBundleDescriptor)desc.getBundleDescriptor();
        WebServicesDescriptor wsDesc = webBundle.getWebServices();
        WebService webService = wsDesc.getWebServiceByName(desc.getServiceLocalPart());
        if (webService == null) {
            return this.getServletAdapterBasedOnWsdlUrl(desc);
        }
        String contextRoot = webBundle.getContextRoot();
        for (WebServiceEndpoint endpoint : webService.getEndpoints()) {
            if (!desc.getServiceName().equals(endpoint.getServiceName()) || !desc.getServiceNamespaceUri().equals(endpoint.getWsdlService().getNamespaceURI())) continue;
            String endPointAddressURI = endpoint.getEndpointAddressUri();
            if (endPointAddressURI == null || endPointAddressURI.isEmpty()) {
                LOG.log(Level.FINEST, "The endpoint address uri is null or empty, returning null.");
                return null;
            }
            Object webSevicePath = endPointAddressURI.startsWith("/") ? endPointAddressURI : "/" + endPointAddressURI;
            String publishingContext = "/" + endpoint.getPublishingUri() + "/" + webService.getWsdlFileUri();
            Adapter adapter = JAXWSAdapterRegistry.getInstance().getAdapter(contextRoot, (String)webSevicePath, publishingContext);
            return adapter instanceof ServletAdapter ? (ServletAdapter)adapter : null;
        }
        return null;
    }

    private ServletAdapter getServletAdapterBasedOnWsdlUrl(ServiceReferenceDescriptor desc) {
        URL wsdl;
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "AS-WSJSR109IMPL-00123", new Object[]{desc.getServiceLocalPart(), desc.getWsdlFileUrl()});
        }
        if ((wsdl = desc.getWsdlFileUrl()) == null) {
            return null;
        }
        String wsdlPath = wsdl.getPath().trim();
        if (!wsdlPath.contains("__container$publishing$subctx")) {
            return null;
        }
        String contextRootAndPath = wsdlPath.substring(1, wsdlPath.indexOf("__container$publishing$subctx") - 1);
        if (contextRootAndPath.isEmpty()) {
            return null;
        }
        String[] contextRootAndPathArray = contextRootAndPath.split("/");
        if (contextRootAndPathArray.length != 2) {
            return null;
        }
        if (contextRootAndPathArray[0] == null) {
            return null;
        }
        String contextRoot = "/" + contextRootAndPathArray[0];
        if (contextRootAndPathArray[1] == null) {
            return null;
        }
        String webSevicePath = "/" + contextRootAndPathArray[1];
        String urlPattern = wsdlPath.substring(contextRoot.length());
        Adapter adapter = JAXWSAdapterRegistry.getInstance().getAdapter(contextRoot, webSevicePath, urlPattern);
        return adapter instanceof ServletAdapter ? (ServletAdapter)adapter : null;
    }

    private static String getBaseAddress(URL wsdlUrl) {
        return wsdlUrl.getProtocol() + "://" + wsdlUrl.getHost() + ":" + wsdlUrl.getPort();
    }

    private void mkDirs(File f) {
        if (!f.mkdirs() && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "AS-WSJSR109IMPL-00093", f);
        }
    }

    private ArrayList<WebServiceFeature> getWebServiceFeatures(ServiceReferenceDescriptor desc) {
        RespectBinding rb;
        Addressing add;
        ArrayList<WebServiceFeature> wsFeatures = new ArrayList<WebServiceFeature>();
        if (desc.isMtomEnabled()) {
            wsFeatures.add((WebServiceFeature)new MTOMFeature(true, desc.getMtomThreshold()));
        }
        if ((add = desc.getAddressing()) != null) {
            wsFeatures.add((WebServiceFeature)new AddressingFeature(add.isEnabled(), add.isRequired(), this.getResponse(add.getResponses())));
        }
        if ((rb = desc.getRespectBinding()) != null) {
            wsFeatures.add((WebServiceFeature)new RespectBindingFeature(rb.isEnabled()));
        }
        Map otherAnnotations = desc.getOtherAnnotations();
        for (Annotation annotation : otherAnnotations.values()) {
            wsFeatures.add(this.getWebServiceFeatureBean(annotation));
        }
        return wsFeatures;
    }

    private AddressingFeature.Responses getResponse(String s) {
        if (s == null) {
            return AddressingFeature.Responses.ALL;
        }
        return Enum.valueOf(AddressingFeature.Responses.class, s);
    }

    private void resolvePortComponentLinks(ServiceReferenceDescriptor desc) throws Exception {
        for (Object element : desc.getPortsInfo()) {
            ServiceRefPortInfo portInfo = (ServiceRefPortInfo)element;
            if (!portInfo.isLinkedToPortComponent()) continue;
            WebServiceEndpoint linkedPortComponent = portInfo.getPortComponentLink();
            if (portInfo.hasWsdlPort()) continue;
            portInfo.setWsdlPort(linkedPortComponent.getWsdlPort());
        }
    }

    private WebServiceFeature getWebServiceFeatureBean(Annotation a) {
        WebServiceFeature bean;
        WebServiceFeatureAnnotation wsfa = a.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
        Class beanClass = wsfa.bean();
        Constructor<?> ftrCtr = null;
        String[] paramNames = null;
        for (Constructor<?> con : beanClass.getConstructors()) {
            FeatureConstructor ftrCtrAnn = con.getAnnotation(FeatureConstructor.class);
            if (ftrCtrAnn == null) continue;
            if (ftrCtr == null) {
                ftrCtr = con;
                paramNames = ftrCtrAnn.value();
                continue;
            }
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_MORETHANONE_FTRCONSTRUCTOR((Object)a, (Object)beanClass));
        }
        if (ftrCtr == null) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_NO_FTRCONSTRUCTOR((Object)a, (Object)beanClass));
        }
        if (ftrCtr.getParameterTypes().length != paramNames.length) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_ILLEGAL_FTRCONSTRUCTOR((Object)a, (Object)beanClass));
        }
        try {
            Object[] params = new Object[paramNames.length];
            for (int i = 0; i < paramNames.length; ++i) {
                Method m = a.annotationType().getDeclaredMethod(paramNames[i], new Class[0]);
                params[i] = m.invoke((Object)a, new Object[0]);
            }
            bean = (WebServiceFeature)ftrCtr.newInstance(params);
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        return bean;
    }
}

