/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class CheckpointManager
implements Runnable {
    TransactionLogManager transactionLogManager;
    private BlockingQueue<Checkpoint> checkpointQueue = new ArrayBlockingQueue<Checkpoint>(5);
    int numCheckpoints;
    private Thread runner;
    public static final Logger logger = Globals.getLogger();

    CheckpointManager(TransactionLogManager transactionLogManager) {
        this.transactionLogManager = transactionLogManager;
    }

    String getPrefix() {
        return "CheckpointManager: " + Thread.currentThread().getName();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.checkpointQueue.take();
                    this.transactionLogManager.doCheckpoint();
                }
            }
            catch (Throwable e) {
                logger.logStack(32, "exception when doing checkpoint", e);
                continue;
            }
            break;
        }
    }

    public synchronized void enqueueCheckpoint() {
        if (this.runner == null) {
            if (Store.getDEBUG()) {
                String msg = this.getPrefix() + " starting checkpoint runner";
                logger.log(4, msg);
            }
            this.runner = new Thread((Runnable)this, "Checkpoint runner");
            this.runner.setDaemon(true);
            this.runner.start();
        }
        Checkpoint checkpoint = new Checkpoint();
        int queueSize = this.checkpointQueue.size();
        if (queueSize > 0) {
            logger.log(32, "enqueued checkpoint request " + this.numCheckpoints + " when there are still " + queueSize + " request(s) in process");
        }
        try {
            this.checkpointQueue.put(checkpoint);
        }
        catch (InterruptedException e) {
            logger.log(16, e.getMessage(), (Throwable)e);
        }
        ++this.numCheckpoints;
    }

    public static class Checkpoint {
    }
}

