/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="collectFeature", label="Collect Feature over Reference", description="In the metamodel, a feature is moved opposite to a multi-valued reference. In the model, the values of the feature are aggregated accordingly.")
public class CollectFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The feature to be moved")
    public EStructuralFeature feature;
    @EdaptParameter(description="The reference opposite to which the feature is moved")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="Both feature and reference must be multi-valued or the reference must be single-valued")
    public boolean checkReferenceMultiplicity(EReference reference) {
        return this.feature.isMany() && reference.isMany() || !reference.isMany();
    }

    @EdaptConstraint(restricts="reference", description="The feature must belong to the reference's type")
    public boolean checkFeatureBelongsToReferenceType(EReference reference) {
        return reference.getEReferenceType().getEStructuralFeatures().contains((Object)this.feature);
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass sourceClass = this.feature.getEContainingClass();
        EClass targetClass = this.reference.getEContainingClass();
        targetClass.getEStructuralFeatures().add((Object)this.feature);
        for (Instance target : model.getAllInstances(targetClass)) {
            Instance source2;
            if (this.reference.isMany()) {
                for (Instance source2 : target.getLinks(this.reference)) {
                    List sourceValue = (List)source2.unset(this.feature);
                    ((List)target.get(this.feature)).addAll(sourceValue);
                }
                continue;
            }
            source2 = (Instance)target.get((EStructuralFeature)this.reference);
            if (source2 == null) continue;
            if (this.feature.isMany()) {
                ((List)target.get(this.feature)).addAll((Collection)source2.unset(this.feature));
                continue;
            }
            target.set(this.feature, source2.unset(this.feature));
        }
        for (Instance source : model.getAllInstances(sourceClass)) {
            this.deleteFeatureValue(source, this.feature);
        }
    }
}

