/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="pullOperation", label="Pull up Operation", description="In the metamodel, a number of operations are pulled up into a common super class. In the model, nothing needs to be done.", breaking=false)
public class PullOperation
extends OperationImplementation {
    @EdaptParameter(main=true, description="The operations to be pulled up")
    public List<EOperation> operations;
    @EdaptParameter(description="The super class to which the operations are pulled")
    public EClass targetClass;

    @EdaptConstraint(restricts="targetClass", description="The operations' classes must have a common super type")
    public boolean checkTargetClass(EClass targetClass) {
        for (EOperation operation : this.operations) {
            if (operation.getEContainingClass().getESuperTypes().contains((Object)targetClass)) continue;
            return false;
        }
        return true;
    }

    @EdaptConstraint(description="The operations' multiplicities have to be the same")
    public boolean checkOperationsSameMultiplicity() {
        return this.hasSameValue(this.operations, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_LowerBound()) && this.hasSameValue(this.operations, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_UpperBound());
    }

    @EdaptConstraint(description="The operations' types have to be the same")
    public boolean checkOperationsSameType() {
        return this.hasSameValue(this.operations, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType());
    }

    @Override
    public void initialize(Metamodel metamodel) {
        EList superTypes;
        if (this.targetClass == null && !(superTypes = this.operations.get(0).getEContainingClass().getESuperTypes()).isEmpty()) {
            this.targetClass = (EClass)superTypes.get(0);
        }
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EOperation mainOperation = this.operations.get(0);
        this.targetClass.getEOperations().add((Object)mainOperation);
        for (EOperation operation : this.operations) {
            if (operation == mainOperation) continue;
            metamodel.delete((EModelElement)operation);
        }
    }
}

