/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.coffee.model.coffee.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emfforms.coffee.model.coffee.Activity;
import org.eclipse.emfforms.coffee.model.coffee.BrewingUnit;
import org.eclipse.emfforms.coffee.model.coffee.CoffeeFactory;
import org.eclipse.emfforms.coffee.model.coffee.CoffeePackage;
import org.eclipse.emfforms.coffee.model.coffee.ControlUnit;
import org.eclipse.emfforms.coffee.model.coffee.Dimension;
import org.eclipse.emfforms.coffee.model.coffee.DipTray;
import org.eclipse.emfforms.coffee.model.coffee.Display;
import org.eclipse.emfforms.coffee.model.coffee.Machine;
import org.eclipse.emfforms.coffee.model.coffee.ManufactoringProcess;
import org.eclipse.emfforms.coffee.model.coffee.Processor;
import org.eclipse.emfforms.coffee.model.coffee.RAM;
import org.eclipse.emfforms.coffee.model.coffee.RamType;
import org.eclipse.emfforms.coffee.model.coffee.SocketConnectorType;
import org.eclipse.emfforms.coffee.model.coffee.WaterTank;
import org.eclipse.emfforms.coffee.model.coffee.impl.ActivityImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.BrewingUnitImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.ControlUnitImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.DimensionImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.DipTrayImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.DisplayImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.MachineImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.ProcessorImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.RAMImpl;
import org.eclipse.emfforms.coffee.model.coffee.impl.WaterTankImpl;

public class CoffeeFactoryImpl
extends EFactoryImpl
implements CoffeeFactory {
    public static CoffeeFactory init() {
        try {
            CoffeeFactory theCoffeeFactory = (CoffeeFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emfforms/example/coffeemodel");
            if (theCoffeeFactory != null) {
                return theCoffeeFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new CoffeeFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 1: {
                return this.createMachine();
            }
            case 2: {
                return this.createControlUnit();
            }
            case 3: {
                return this.createBrewingUnit();
            }
            case 4: {
                return this.createDipTray();
            }
            case 5: {
                return this.createWaterTank();
            }
            case 6: {
                return this.createProcessor();
            }
            case 7: {
                return this.createRAM();
            }
            case 8: {
                return this.createActivity();
            }
            case 9: {
                return this.createDimension();
            }
            case 10: {
                return this.createDisplay();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.createSocketConnectorTypeFromString(eDataType, initialValue);
            }
            case 12: {
                return this.createManufactoringProcessFromString(eDataType, initialValue);
            }
            case 13: {
                return this.createRamTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 11: {
                return this.convertSocketConnectorTypeToString(eDataType, instanceValue);
            }
            case 12: {
                return this.convertManufactoringProcessToString(eDataType, instanceValue);
            }
            case 13: {
                return this.convertRamTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Machine createMachine() {
        MachineImpl machine = new MachineImpl();
        return machine;
    }

    @Override
    public ControlUnit createControlUnit() {
        ControlUnitImpl controlUnit = new ControlUnitImpl();
        return controlUnit;
    }

    @Override
    public BrewingUnit createBrewingUnit() {
        BrewingUnitImpl brewingUnit = new BrewingUnitImpl();
        return brewingUnit;
    }

    @Override
    public DipTray createDipTray() {
        DipTrayImpl dipTray = new DipTrayImpl();
        return dipTray;
    }

    @Override
    public WaterTank createWaterTank() {
        WaterTankImpl waterTank = new WaterTankImpl();
        return waterTank;
    }

    @Override
    public Processor createProcessor() {
        ProcessorImpl processor = new ProcessorImpl();
        return processor;
    }

    @Override
    public RAM createRAM() {
        RAMImpl ram = new RAMImpl();
        return ram;
    }

    @Override
    public Activity createActivity() {
        ActivityImpl activity = new ActivityImpl();
        return activity;
    }

    @Override
    public Dimension createDimension() {
        DimensionImpl dimension = new DimensionImpl();
        return dimension;
    }

    @Override
    public Display createDisplay() {
        DisplayImpl display = new DisplayImpl();
        return display;
    }

    public SocketConnectorType createSocketConnectorTypeFromString(EDataType eDataType, String initialValue) {
        SocketConnectorType result = SocketConnectorType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSocketConnectorTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ManufactoringProcess createManufactoringProcessFromString(EDataType eDataType, String initialValue) {
        ManufactoringProcess result = ManufactoringProcess.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertManufactoringProcessToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RamType createRamTypeFromString(EDataType eDataType, String initialValue) {
        RamType result = RamType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRamTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public CoffeePackage getCoffeePackage() {
        return (CoffeePackage)this.getEPackage();
    }

    @Deprecated
    public static CoffeePackage getPackage() {
        return CoffeePackage.eINSTANCE;
    }
}

