/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.validation;

import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;

public final class VDiagnosticHelper {
    private VDiagnosticHelper() {
    }

    public static boolean isEqual(VDiagnostic vDiagnostic1, VDiagnostic vDiagnostic2) {
        if (vDiagnostic1 == null && vDiagnostic2 == null) {
            return true;
        }
        if (vDiagnostic1 == null) {
            return false;
        }
        if (vDiagnostic2 == null) {
            return false;
        }
        boolean arePropertiesEqual = VDiagnosticHelper.arePropertiesEqual(vDiagnostic1, vDiagnostic2);
        if (!arePropertiesEqual) {
            return false;
        }
        int i = 0;
        while (i < vDiagnostic1.getDiagnostics().size()) {
            Diagnostic diagnostic2;
            Diagnostic diagnostic1 = (Diagnostic)vDiagnostic1.getDiagnostics().get(i);
            if (!VDiagnosticHelper.areUnderlyingDiagnosticsEqual(diagnostic1, diagnostic2 = (Diagnostic)vDiagnostic2.getDiagnostics().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean arePropertiesEqual(VDiagnostic vDiagnostic1, VDiagnostic vDiagnostic2) {
        if (vDiagnostic1.getHighestSeverity() != vDiagnostic2.getHighestSeverity()) {
            return false;
        }
        if (!vDiagnostic1.getMessage().equals(vDiagnostic2.getMessage())) {
            return false;
        }
        return vDiagnostic1.getDiagnostics().size() == vDiagnostic2.getDiagnostics().size();
    }

    private static boolean areUnderlyingDiagnosticsEqual(Diagnostic diagnostic1, Diagnostic diagnostic2) {
        if (diagnostic1.getSeverity() != diagnostic2.getSeverity()) {
            return false;
        }
        if (diagnostic1.getData().size() != diagnostic2.getData().size()) {
            return false;
        }
        if (diagnostic1.getChildren().size() != diagnostic2.getChildren().size()) {
            return false;
        }
        int j = 0;
        while (j < diagnostic1.getData().size()) {
            Object data2;
            Object data1 = diagnostic1.getData().get(j);
            if (!data1.equals(data2 = diagnostic2.getData().get(j))) {
                return false;
            }
            ++j;
        }
        int i = 0;
        while (i < diagnostic1.getChildren().size()) {
            if (!VDiagnosticHelper.areUnderlyingDiagnosticsEqual((Diagnostic)diagnostic1.getChildren().get(i), (Diagnostic)diagnostic2.getChildren().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static VDiagnostic clean(VDiagnostic value) {
        VDiagnostic result = VViewFactory.eINSTANCE.createDiagnostic();
        LinkedHashMap<EObject, Diagnostic> map = new LinkedHashMap<EObject, Diagnostic>();
        for (Object object : value.getDiagnostics()) {
            Diagnostic diagnostic = (Diagnostic)object;
            if (diagnostic.getData() == null || diagnostic.getData().size() == 0) continue;
            EObject eObject = (EObject)diagnostic.getData().get(0);
            if (map.containsKey(eObject)) {
                ((DiagnosticChain)map.get(eObject)).merge(diagnostic);
                continue;
            }
            map.put(eObject, diagnostic);
        }
        result.getDiagnostics().addAll(map.values());
        return result;
    }
}

